/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;

public class StubBaseWithFlags<T extends PsiElement>
extends StubBase<T> {
    private final byte myFlags;

    protected StubBaseWithFlags(StubElement parent, @NotNull IStubElementType elementType, byte flags) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/aspectj/psi/stub/impl/StubBaseWithFlags", "<init>"));
        }
        super(parent, elementType);
        this.myFlags = flags;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public boolean isSet(Flag flag) {
        return (this.myFlags & flag.getFlag()) != 0;
    }

    public static byte pack(boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        return StubBaseWithFlags.pack(isDeprecated, hasDeprecatedAnnotation, false, false, hasDocComment);
    }

    public static byte pack(boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean isConstructor, boolean isVarArgs, boolean hasDocComment) {
        byte flags = 0;
        if (isDeprecated) {
            flags = (byte)(flags | Flag.DEPRECATED.getFlag());
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | Flag.DEPRECATED_ANNOTATION.getFlag());
        }
        if (isConstructor) {
            flags = (byte)(flags | Flag.CONSTRUCTOR.getFlag());
        }
        if (isVarArgs) {
            flags = (byte)(flags | Flag.VAR_ARGS.getFlag());
        }
        if (hasDocComment) {
            flags = (byte)(flags | Flag.HAS_DOC_COMMENT.getFlag());
        }
        return flags;
    }

    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag DEPRECATED = new Flag(1);
        public static final /* enum */ Flag DEPRECATED_ANNOTATION = new Flag(2);
        public static final /* enum */ Flag CONSTRUCTOR = new Flag(4);
        public static final /* enum */ Flag VAR_ARGS = new Flag(8);
        public static final /* enum */ Flag HAS_DOC_COMMENT = new Flag(16);
        private final byte myFlag;
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String name) {
            return Enum.valueOf(Flag.class, name);
        }

        private Flag(int flag) {
            assert (flag < 127);
            this.myFlag = (byte)flag;
        }

        private byte getFlag() {
            return this.myFlag;
        }

        static {
            $VALUES = new Flag[]{DEPRECATED, DEPRECATED_ANNOTATION, CONSTRUCTOR, VAR_ARGS, HAS_DOC_COMMENT};
        }
    }
}

