/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeMethodIndex;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.psi.impl.PsiInterTypeMethodImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeMethodStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiInterTypeMethodStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.InterTypeMethodElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AjMethodElementType
extends AjStubElementType<PsiInterTypeMethodStub, PsiInterTypeMethod> {
    public AjMethodElementType() {
        super("INTER_TYPE_METHOD");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        InterTypeMethodElement interTypeMethodElement = new InterTypeMethodElement();
        if (interTypeMethodElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "createCompositeNode"));
        }
        return interTypeMethodElement;
    }

    public PsiInterTypeMethod createPsi(@NotNull PsiInterTypeMethodStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "createPsi"));
        }
        return new PsiInterTypeMethodImpl(stub);
    }

    @Override
    public PsiInterTypeMethod createPsi(ASTNode node) {
        return new PsiInterTypeMethodImpl(node);
    }

    public PsiInterTypeMethodStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String className = null;
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            LighterASTNode pType;
            List params;
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type == AspectJElementType.INTER_TYPE_REFERENCE) {
                className = AjMethodElementType.getReferencedClassName(tree, child);
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
                continue;
            }
            if (type == JavaTokenType.NEW_KEYWORD) {
                isConstructor = true;
                continue;
            }
            if (type != JavaElementType.PARAMETER_LIST || (params = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)child, (IElementType)JavaElementType.PARAMETER)).isEmpty() || (pType = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)((LighterASTNode)params.get(params.size() - 1)), (IElementType)JavaElementType.TYPE)) == null) continue;
            isVarArgs = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)pType, (IElementType)JavaTokenType.ELLIPSIS) != null;
        }
        name = name == null && isConstructor ? className : name;
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create((LighterAST)tree, (LighterASTNode)node, (StubElement)parentStub);
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, isConstructor, isVarArgs, hasDocComment);
        return new PsiInterTypeMethodStubImpl(parentStub, className, name, typeInfo, flags);
    }

    public void serialize(@NotNull PsiInterTypeMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "serialize"));
        }
        dataStream.writeName(stub.getClassName());
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE((StubOutputStream)dataStream, (TypeInfo)stub.getReturnTypeText(false));
        dataStream.writeByte((int)((PsiInterTypeMethodStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiInterTypeMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "deserialize"));
        }
        StringRef className = dataStream.readName();
        StringRef name = dataStream.readName();
        TypeInfo typeInfo = TypeInfo.readTYPE((StubInputStream)dataStream);
        byte flags = dataStream.readByte();
        PsiInterTypeMethodStubImpl psiInterTypeMethodStubImpl = new PsiInterTypeMethodStubImpl(parentStub, StringRef.toString((StringRef)className), StringRef.toString((StringRef)name), typeInfo, flags);
        if (psiInterTypeMethodStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "deserialize"));
        }
        return psiInterTypeMethodStubImpl;
    }

    public void indexStub(@NotNull PsiInterTypeMethodStub stub, @NotNull IndexSink sink) {
        String className;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/aspectj/psi/stub/AjMethodElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, (Object)name);
            if (RecordUtil.isStaticNonPrivateMember((StubElement)stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)stub.getReturnTypeText(false).getShortTypeText());
            }
        }
        if ((className = stub.getClassName()) != null) {
            sink.occurrence(AspectJInterTypeMethodIndex.KEY, (Object)className);
        }
    }
}

