/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.index.stub.AjShortClassNameIndex;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeClassIndex;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.impl.PsiInterTypeClassImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeClassStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiInterTypeClassStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.InterTypeClassElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AjClassElementType
extends AjStubElementType<PsiInterTypeClassStub, PsiInterTypeClass> {
    public AjClassElementType() {
        super("INTER_TYPE_CLASS");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        InterTypeClassElement interTypeClassElement = new InterTypeClassElement();
        if (interTypeClassElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "createCompositeNode"));
        }
        return interTypeClassElement;
    }

    public PsiInterTypeClass createPsi(@NotNull PsiInterTypeClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "createPsi"));
        }
        return new PsiInterTypeClassImpl(stub);
    }

    @Override
    public PsiInterTypeClass createPsi(ASTNode node) {
        return new PsiInterTypeClassImpl(node);
    }

    public PsiInterTypeClassStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String className = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == AspectJElementType.INTER_TYPE_REFERENCE) {
                className = AjClassElementType.getReferencedClassName(tree, child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiInterTypeClassStubImpl(parentStub, className, name, flags);
    }

    public void serialize(@NotNull PsiInterTypeClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "serialize"));
        }
        dataStream.writeName(stub.getClassName());
        dataStream.writeName(stub.getName());
        dataStream.writeByte((int)((PsiInterTypeClassStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiInterTypeClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "deserialize"));
        }
        StringRef className = dataStream.readName();
        StringRef name = dataStream.readName();
        byte flags = dataStream.readByte();
        PsiInterTypeClassStubImpl psiInterTypeClassStubImpl = new PsiInterTypeClassStubImpl(parentStub, StringRef.toString((StringRef)className), StringRef.toString((StringRef)name), flags);
        if (psiInterTypeClassStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "deserialize"));
        }
        return psiInterTypeClassStubImpl;
    }

    public void indexStub(@NotNull PsiInterTypeClassStub stub, @NotNull IndexSink sink) {
        String className;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name);
            sink.occurrence(AjShortClassNameIndex.KEY, (Object)name);
        }
        if ((className = stub.getClassName()) != null) {
            sink.occurrence(AspectJInterTypeClassIndex.KEY, (Object)className);
        }
    }

    public String getId(@NotNull PsiInterTypeClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjClassElementType", "getId"));
        }
        String name = stub.getName();
        if (name != null) {
            return name;
        }
        return super.getId((StubElement)stub);
    }
}

