/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInterTypeReferenceImpl
extends ASTWrapperPsiElement
implements PsiInterTypeReference {
    private CachedValue<PsiClass> myRefCache;

    public PsiInterTypeReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "<init>"));
        }
        super(node);
        this.myRefCache = null;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getReferenceElement() {
        PsiTypeElement type = (PsiTypeElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiTypeElement.class);
        PsiJavaCodeReferenceElement reference = type.getInnermostComponentReferenceElement();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = reference != null ? reference : (PsiJavaCodeReferenceElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)type, PsiJavaCodeReferenceElement.class);
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "getReferenceElement"));
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @Nullable
    public PsiClass getReferencedClass() {
        return (PsiClass)this.getRefCache().getValue();
    }

    private synchronized CachedValue<PsiClass> getRefCache() {
        if (this.myRefCache == null) {
            this.myRefCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                PsiClass value = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                    public PsiClass compute() {
                        return (PsiClass)PsiInterTypeReferenceImpl.this.getReferenceElement().resolve();
                    }
                });
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{value != null ? value : PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        return this.myRefCache;
    }

    @Override
    @NotNull
    public String getReferencedClassName() {
        PsiJavaCodeReferenceElement refElement = this.getReferenceElement();
        PsiElement nameElement = refElement.getReferenceNameElement();
        assert (nameElement != null) : refElement;
        String string = nameElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "getReferencedClassName"));
        }
        return string;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "processDeclarations"));
        }
        ElementClassHint hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (hint != null && hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass target;
            String name;
            Pair<Integer, PsiTypeElement> result;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if (nameHint != null && (result = InterTypeResolveUtil.findTypeReferenceByName(this, name = nameHint.getName(state))) != null && ((PsiTypeElement)result.second).equals(place.getParent()) && (target = this.getReferencedClass()) != null && !InterTypeResolveUtil.resolveToClassTypeParameter(target, (Integer)result.first, processor, state, name)) {
                return false;
            }
            PsiAspect aspect = this.getAspect();
            if (aspect != null && !aspect.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            this.getContainingFile().processDeclarations(processor, state, lastParent, place);
            return false;
        }
        return true;
    }

    @Nullable
    private PsiAspect getAspect() {
        PsiElement aspect;
        PsiElement declaration = this.getParent();
        if (declaration != null && (aspect = declaration.getParent()) instanceof PsiAspect) {
            return (PsiAspect)aspect;
        }
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/aspectj/psi/impl/PsiInterTypeReferenceImpl", "accept"));
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitInterTypeReference(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        return "PsiInterTypeReference:" + this.getText().trim();
    }
}

