/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.index.file;

import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InterTypeDeclarationIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"aj.declarations");
    private static final int VERSION = 1;
    private static final MyInputFilter INPUT_FILTER = new MyInputFilter();
    private static final MyDataIndexer INDEXER = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = INDEXER;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(String key, Project project) {
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)key, ProjectScope.getProjectScope((Project)project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex", "getFilesByKey"));
        }
        return collection;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = INPUT_FILTER;
        if (myInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex", "getInputFilter"));
        }
        return myInputFilter;
    }

    private static class MyInputFilter
    extends DefaultFileTypeSpecificInputFilter {
        private MyInputFilter() {
            super(new FileType[]{AspectJFileType.INSTANCE});
        }

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex$MyInputFilter", "acceptInput"));
            }
            return file.getFileSystem() instanceof LocalFileSystem;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex$MyDataIndexer", "map"));
            }
            HashMap<String, Void> result = new HashMap<String, Void>();
            PsiFile psiFile = inputData.getPsiFile();
            if (psiFile instanceof PsiAspectJFile) {
                for (PsiAspect aspect : ((PsiAspectJFile)psiFile).getAspects()) {
                    for (PsiInterTypeDeclaration declaration : aspect.getInterTypeDeclarations()) {
                        result.put(declaration.getInterTypeReference().getReferencedClassName(), null);
                    }
                }
            }
            HashMap<String, Void> hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/index/file/InterTypeDeclarationIndex$MyDataIndexer", "map"));
            }
            return hashMap;
        }
    }
}

