/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.augment.LightInterTypeMethod;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.AjAdvice;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.util.PseudoImplLightClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;

public class PrivateMemberAccessAnnotator
extends ElementAnnotator<PsiJavaCodeReferenceElement> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiJavaCodeReferenceElement reference) {
        PsiElement block = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiMember.class, AjAdvice.class});
        if (block == null) {
            return false;
        }
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiMember)) {
            return false;
        }
        if (((PsiMember)target).getContainingClass() instanceof PseudoImplLightClass || target instanceof LightInterTypeMethod && ((LightInterTypeMethod)target).hasModifierProperty("abstract")) {
            return false;
        }
        if (!(target instanceof PsiInterTypeDeclaration || block instanceof PsiInterTypeDeclaration || block instanceof AjAdvice)) {
            return false;
        }
        PsiModifierList modList = ((PsiMember)target).getModifierList();
        if (modList == null || !modList.hasModifierProperty("private")) {
            return false;
        }
        PsiElement targetContainer = target.getParent();
        PsiElement callerContainer = block.getParent();
        if (!(targetContainer instanceof PsiClass) || targetContainer.equals(callerContainer) || callerContainer instanceof PsiAspect && ((PsiAspect)callerContainer).isPrivileged()) {
            return false;
        }
        PsiElement nameElement = reference.getReferenceNameElement();
        PsiElement refElement = nameElement != null ? nameElement : reference;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)target, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String containerName = HighlightMessageUtil.getSymbolName((PsiElement)targetContainer, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        holder.createErrorAnnotation(refElement, AspectJBundle.message("highlighting.private.access", symbolName, containerName));
        return true;
    }
}

