/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.lang.aspectj.debug.AspectJDebugUtil;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspectJPositionManager
implements PositionManager {
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(AspectJFileType.INSTANCE);

    public AspectJPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        String signature;
        PsiClass psiClass;
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = -1;
        try {
            lineNumber = location.lineNumber() - 1;
        }
        catch (InternalException internalException) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        if (lineNumber < 0) {
            lineNumber = -1;
        }
        PsiFile psiFile2 = psiFile = (psiClass = AspectJDebugUtil.findClassByLocation(location, this.myDebugProcess.getProject(), this.myDebugProcess.getSearchScope())) != null ? psiClass.getNavigationElement().getContainingFile() : null;
        if (psiFile instanceof PsiAspectJFile) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        if (psiFile instanceof PsiJavaFile && lineNumber == 0 && (signature = location.method().signature()) != null) {
            try {
                for (PsiMethod candidate : psiClass.findMethodsByName(location.method().name(), false)) {
                    if (!(candidate instanceof PsiInterTypeMethod) || !JVMNameUtil.getJVMSignature((PsiMethod)candidate).getName((DebugProcessImpl)this.myDebugProcess).equals(signature)) continue;
                    return SourcePosition.createFromLine((PsiFile)candidate.getContainingFile(), (int)-1);
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        throw NoDataException.INSTANCE;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "getAllClasses"));
        }
        AspectJDebugUtil.checkDomain(position);
        AspectJDebugUtil.ClassData classData = AspectJDebugUtil.findClassAt(position);
        if (classData == null) {
            List<ReferenceType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "getAllClasses"));
            }
            return list;
        }
        if (classData.isTopLevel) {
            List list = this.myDebugProcess.getVirtualMachineProxy().classesByName(classData.topClassName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "getAllClasses"));
            }
            return list;
        }
        List outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(classData.topClassName);
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
        for (ReferenceType outer : outers) {
            ReferenceType nested = AspectJDebugUtil.findNestedClass(outer, classData.aClass, position, this.myDebugProcess.getVirtualMachineProxy());
            if (nested == null) continue;
            result.add(nested);
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "getAllClasses"));
        }
        return arrayList;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        block6: {
            List<Location> list;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "locationsOfLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "locationsOfLine"));
            }
            AspectJDebugUtil.checkDomain(position);
            try {
                int line = position.getLine() + 1;
                List<Location> locations = type.locationsOfLine("Java", null, line);
                if (locations.size() <= 0) break block6;
                list = locations;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "locationsOfLine"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "locationsOfLine"));
        }
        return list;
    }

    @Nullable
    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "createPrepareRequest"));
        }
        AspectJDebugUtil.checkDomain(position);
        AspectJDebugUtil.ClassData classData = AspectJDebugUtil.findClassAt(position);
        if (classData == null) {
            return null;
        }
        if (classData.isTopLevel) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, classData.topClassName);
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                PositionManager positionManager = debuggerProcess.getPositionManager();
                try {
                    if (positionManager.locationsOfLine(referenceType, position).size() > 0) {
                        requestor.processClassPrepare(debuggerProcess, referenceType);
                    } else {
                        List positionClasses = positionManager.getAllClasses(position);
                        if (positionClasses.contains(referenceType)) {
                            requestor.processClassPrepare(debuggerProcess, referenceType);
                        }
                    }
                }
                catch (NoDataException noDataException) {
                    // empty catch block
                }
            }
        }, classData.topClassName + "$*");
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/debug/AspectJPositionManager", "getAcceptedFileTypes"));
        }
        return set;
    }
}

