/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.augment;

import com.intellij.lang.Language;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightInterTypeMethod
extends LightMethod
implements PsiInterTypeMethod {
    private final PsiInterTypeMethod myOriginal;
    private final PsiClass myContainingClass;
    private final LightModifierList myModifierList;

    public LightInterTypeMethod(@NotNull PsiInterTypeMethod original, @NotNull PsiClass containingClass) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "<init>"));
        }
        super(original.getManager(), (PsiMethod)original, containingClass);
        this.myOriginal = original;
        this.myContainingClass = containingClass;
        this.myModifierList = containingClass.isInterface() ? new LightModifierList(original.getManager(), (Language)JavaLanguage.INSTANCE, new String[]{"public", "abstract"}) : new LightModifierList((PsiModifierListOwner)original);
        this.setNavigationElement(this.myOriginal);
    }

    public PsiElement getParent() {
        return this.myOriginal.getAspect();
    }

    public PsiFile getContainingFile() {
        return this.myOriginal.getContainingFile();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "hasModifierProperty"));
        }
        return this.myModifierList.hasModifierProperty(name);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "getModifierList"));
        }
        return lightModifierList;
    }

    public PsiCodeBlock getBody() {
        return this.myContainingClass.isInterface() ? null : super.getBody();
    }

    public PsiElement getProblemTarget() {
        return this.myOriginal.getProblemTarget();
    }

    @Override
    @NotNull
    public PsiAspect getAspect() {
        PsiAspect psiAspect = this.myOriginal.getAspect();
        if (psiAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "getAspect"));
        }
        return psiAspect;
    }

    @Override
    @NotNull
    public PsiInterTypeReference getInterTypeReference() {
        PsiInterTypeReference psiInterTypeReference = this.myOriginal.getInterTypeReference();
        if (psiInterTypeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "getInterTypeReference"));
        }
        return psiInterTypeReference;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/aspectj/augment/LightInterTypeMethod", "accept"));
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitInterTypeMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    public PsiElement copy() {
        return new LightInterTypeMethod(this.myOriginal, this.myContainingClass);
    }

    public PsiInterTypeMethod getDelegate() {
        return this.myOriginal;
    }

    public boolean isDelegateTo(PsiMethod method) {
        return this.myOriginal == method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightInterTypeMethod method = (LightInterTypeMethod)o;
        return this.myOriginal.equals(method.myOriginal);
    }

    public int hashCode() {
        return this.myOriginal.hashCode();
    }
}

