/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import net.sourceforge.transparent.actions.FileAction;

public abstract class SynchronousAction
extends FileAction {
    @Override
    protected List<VcsException> runAction(AnActionEvent e) {
        return super.runAction(e);
    }

    @Override
    protected void execute(AnActionEvent e, List<VcsException> errors) {
        VirtualFile[] files;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        for (VirtualFile file : files = VcsUtil.getVirtualFiles((AnActionEvent)e)) {
            if (!this.isEnabled(file, project)) continue;
            this.executeOnFile(file, errors, project);
        }
    }

    protected void executeOnFile(VirtualFile file, List<VcsException> errors, Project project) {
        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
        try {
            this.perform(file, project);
            mgr.fileDirty(file);
        }
        catch (VcsException ex) {
            ex.setVirtualFile(file);
            errors.add(ex);
        }
        catch (RuntimeException ex) {
            VcsException vcsEx = new VcsException((Throwable)ex);
            vcsEx.setVirtualFile(file);
            errors.add(vcsEx);
        }
        this.handleRecursiveExecute(file, errors, project);
    }

    private void handleRecursiveExecute(VirtualFile file, List<VcsException> errors, Project project) {
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.executeOnFile(child, errors, project);
            }
        }
    }

    protected abstract void perform(VirtualFile var1, Project var2) throws VcsException;
}

