/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.actions.AsynchronousAction;
import org.jetbrains.annotations.NonNls;

public class PropertiesAction
extends AsynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Properties";

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        if (e.getPresentation().isEnabled()) {
            Project project = PropertiesAction.getEventProject((AnActionEvent)e);
            FileStatusManager mgr = FileStatusManager.getInstance((Project)project);
            e.getPresentation().setEnabled(mgr.getStatus(files[0]) != FileStatus.HIJACKED);
        }
    }

    @Override
    public void perform(VirtualFile file, Project project) {
        PropertiesAction.cleartool("describe", "-g", file.getPath());
    }

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }
}

