/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import net.sourceforge.transparent.CCaseEditFileProvider;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.SynchronousAction;
import org.jetbrains.annotations.NonNls;

public class HijackAction
extends SynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Hijack File";

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        boolean isEnabled = e.getPresentation().isEnabled();
        TransparentVcs host = HijackAction.getHost(e);
        boolean isVisible = host != null && host.getConfig() != null;
        e.getPresentation().setVisible(isVisible);
        e.getPresentation().setEnabled(isVisible && isEnabled && host.getConfig().isOffline());
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        CCaseViewsManager mgr = CCaseViewsManager.getInstance(project);
        CCaseViewsManager.ViewInfo view = mgr.getViewByFile(file);
        FileStatus status = HijackAction.getFileStatus(project, file);
        return !file.isWritable() && status != FileStatus.UNKNOWN && view != null && view.isSnapshot;
    }

    @Override
    protected void perform(VirtualFile file, Project project) throws VcsException {
        CCaseEditFileProvider.hijackFile(file);
    }
}

