/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.AsynchronousAction;
import org.jetbrains.annotations.NonNls;

public class FindProjectCheckoutsAction
extends AsynchronousAction {
    @NonNls
    private static final String WARNING_TEXT = "In graphical mode only one content root as a VOB object can be shown.";
    @NonNls
    private static final String WARNING_TITLE = "Show One VOB Path";
    @NonNls
    private static final String ACTION_NAME = "Find Project Checkouts";

    @Override
    public void perform(VirtualFile file, Project project) {
        TransparentVcs host = TransparentVcs.getInstance(project);
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile[] roots = mgr.getRootsUnderVcs((AbstractVcs)host);
        if (roots.length > 1) {
            Messages.showWarningDialog((Project)project, (String)WARNING_TEXT, (String)WARNING_TITLE);
        }
        FindProjectCheckoutsAction.cleartool("lscheckout", "-g", roots[0].getPath());
    }

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }
}

