/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.VcsAction;
import net.sourceforge.transparent.exceptions.ClearCaseException;

public abstract class FileAction
extends VcsAction {
    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        boolean enabled = project != null && files.length > 0;
        for (VirtualFile file : files) {
            enabled &= this.isEnabled(file, project);
        }
        e.getPresentation().setEnabled(enabled);
    }

    protected boolean isEnabled(VirtualFile file, Project project) {
        return FileAction.getFileStatus(project, file) != FileStatus.ADDED;
    }

    public static void cleartool(String ... subcmd) throws ClearCaseException {
        TransparentVcs.cleartool(subcmd);
    }
}

