/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.FilterDescendantVirtualFileConvertible;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ReadonlyStatusIsVisibleActivationCheck;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.transparent.Annotations.CCaseAnnotationProvider;
import net.sourceforge.transparent.BaseOrUCM;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseConfigurable;
import net.sourceforge.transparent.CCaseEditFileProvider;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseUpdateEnvironment;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider;
import net.sourceforge.transparent.ChangeManagement.TransparentI;
import net.sourceforge.transparent.CheckedOutStatus;
import net.sourceforge.transparent.Checkin.CCaseCheckinEnvironment;
import net.sourceforge.transparent.Checkin.CCaseRollbackEnvironment;
import net.sourceforge.transparent.ClearCase;
import net.sourceforge.transparent.ClearCaseDecorator;
import net.sourceforge.transparent.CommandLineClearCase;
import net.sourceforge.transparent.ContentRevisionFactory;
import net.sourceforge.transparent.History.CCaseDiffProvider;
import net.sourceforge.transparent.History.CCaseHistoryProvider;
import net.sourceforge.transparent.Runner;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.VFSListener;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TransparentVcs
extends AbstractVcs
implements ProjectComponent,
JDOMExternalizable,
TransparentI {
    public static final Logger LOG = Logger.getInstance((String)"#net.sourceforge.transparent.TransparentVcs");
    private static final String NAME = "ClearCase";
    private static final VcsKey ourKey = TransparentVcs.createKey((String)"ClearCase");
    @NonNls
    public static final String TEMPORARY_FILE_SUFFIX = ".deleteAndAdd";
    @NonNls
    public static final String CLEARTOOL_CMD = "cleartool";
    @NonNls
    private static final String PERSISTENCY_REMOVED_FILE_TAG = "ClearCasePersistencyRemovedFile";
    @NonNls
    private static final String PERSISTENCY_REMOVED_FOLDER_TAG = "ClearCasePersistencyRemovedFolder";
    @NonNls
    private static final String PERSISTENCY_RENAMED_FILE_TAG = "ClearCasePersistencyRenamedFile";
    @NonNls
    private static final String PERSISTENCY_RENAMED_FOLDER_TAG = "ClearCasePersistencyRenamedFolder";
    @NonNls
    private static final String PERSISTENCY_CHECKED_OUT_FOLDER_TAG = "ClearCasePersistencyCheckedOutFolder";
    @NonNls
    private static final String PERSISTENCY_NEW_FILE_TAG = "ClearCasePersistencyNewFile";
    @NonNls
    private static final String PERSISTENCY_MODIFIED_FILE_TAG = "ClearCasePersistencyModifiedFile";
    @NonNls
    private static final String PERSISTENCY_DELETED_FILE_TAG = "ClearCasePersistencyDeletedFile";
    @NonNls
    private static final String PERSISTENCY_DELETED_FOLDER_TAG = "ClearCasePersistencyDeletedFolder";
    @NonNls
    private static final String PATH_DELIMITER = "%%%";
    @NonNls
    private static final String CCASE_KEEP_FILE_SIG = "*.keep";
    @NonNls
    private static final String CCASE_KEEP_FILE_MID_SIG = "*.keep.*";
    @NonNls
    private static final String CCASE_CONTRIB_FILE_SIG = "*.contrib";
    @NonNls
    private static final String CCASE_CONTRIB_FILE_MID_SIG = "*.contrib.*";
    @NonNls
    private static final String CCASE_FINDMERGE_FILE_SIG = "findmerge.log.*";
    @NonNls
    private static final String CCASE_UPDATE_LOG_FILE_SIG = "*.updt";
    @NonNls
    private static final String HIJACKED_EXT = ".hijacked";
    @NonNls
    private static final String CHANGE_ACTIVITY_CMD = "chactivity";
    @NonNls
    private static final String RESERVED_SIG = "reserved";
    @NonNls
    private static final String UNRESERVED_SIG = "unreserved";
    @NonNls
    private static final String ALREADY_CHECKEDOUT_SIG = "already checked out";
    @NonNls
    private static final String NOT_A_VOB_OBJECT_SIG = "Not a vob object";
    private final BaseOrUCM myBaseOrUCM;
    public static final Key<Boolean> SUCCESSFUL_CHECKOUT = new Key("SUCCESSFUL_CHECKOUT");
    public static final Key<Boolean> MERGE_CONFLICT = new Key("MERGE_CONFLICT");
    public Set<String> removedFiles;
    public Set<String> removedFolders;
    private final Set<VirtualFile> newFiles;
    public Map<String, String> renamedFiles;
    public Map<String, String> renamedFolders;
    public Set<String> deletedFiles;
    public Set<String> deletedFolders;
    public Set<String> checkedOutFolders;
    private final Set<VirtualFile> modifiedFiles;
    private ClearCase clearcase;
    private CCaseConfig config;
    private CCaseDiffProvider myDiffProvider;
    private CCaseCheckinEnvironment checkinEnvironment;
    private CCaseRollbackEnvironment rollbackEnvironment;
    private CCaseUpdateEnvironment updateEnvironment;
    private ChangeProvider changeProvider;
    private EditFileProvider editProvider;
    private CCaseHistoryProvider historyProvider;
    private CCaseAnnotationProvider annotationProvider;
    private VcsShowSettingOption myCheckoutOptions;
    private VcsShowConfirmationOption addConfirmation;
    private VcsShowConfirmationOption removeConfirmation;
    private VirtualFileListener listener;
    private boolean myActivatePolicyCalculateUCM;
    private static final boolean ourActivatePolicyCalculateUCMDefault = false;

    public TransparentVcs(@NotNull Project project, UltimateVerifier verifier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "net/sourceforge/transparent/TransparentVcs", "<init>"));
        }
        super(project, NAME);
        PluginVerifier.verifyUltimatePlugin(verifier);
        this.removedFiles = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.removedFolders = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.newFiles = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.deletedFiles = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.deletedFolders = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.renamedFiles = Collections.synchronizedMap(new HashMap());
        this.renamedFolders = Collections.synchronizedMap(new HashMap());
        this.checkedOutFolders = Collections.synchronizedSet(new HashSet());
        this.modifiedFiles = Collections.synchronizedSet(new com.intellij.util.containers.HashSet());
        this.myBaseOrUCM = new BaseOrUCM(this);
        this.myActivatePolicyCalculateUCM = false;
    }

    @NotNull
    public String getComponentName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/TransparentVcs", "getComponentName"));
        }
        return string;
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getMenuItemText() {
        return super.getMenuItemText();
    }

    public static boolean isCmdImpl() {
        return true;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.addConfirmation;
    }

    public VcsShowConfirmationOption getRemoveConfirmation() {
        return this.removeConfirmation;
    }

    public Configurable getConfigurable() {
        return new CCaseConfigurable(this.myProject);
    }

    public CCaseConfig getConfig() {
        return this.config;
    }

    public ChangeProvider getChangeProvider() {
        return this.changeProvider;
    }

    public EditFileProvider getEditFileProvider() {
        return this.editProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return this.historyProvider;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public CheckinEnvironment createCheckinEnvironment() {
        return this.config == null || !this.config.isOffline() ? this.checkinEnvironment : null;
    }

    public RollbackEnvironment createRollbackEnvironment() {
        return this.config == null || !this.config.isOffline() ? this.rollbackEnvironment : null;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        CCaseViewsManager viewsMgr = CCaseViewsManager.getInstance(this.myProject);
        return viewsMgr.isAnySnapshotView() ? this.updateEnvironment : null;
    }

    public static TransparentVcs getInstance(Project project) {
        return (TransparentVcs)PeriodicalTasksCloser.getInstance().safeGetComponent(project, TransparentVcs.class);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        this.changeProvider = new CCaseChangeProvider(this.myProject, this);
        this.updateEnvironment = new CCaseUpdateEnvironment(this.myProject);
        this.checkinEnvironment = new CCaseCheckinEnvironment(this.myProject, this);
        this.rollbackEnvironment = new CCaseRollbackEnvironment(this.myProject, this);
        this.editProvider = new CCaseEditFileProvider(this);
        this.historyProvider = new CCaseHistoryProvider(this.myProject);
        this.annotationProvider = new CCaseAnnotationProvider(this.myProject, this);
        this.myDiffProvider = new CCaseDiffProvider(this.myProject);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        this.addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.removeConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
    }

    public void projectClosed() {
    }

    public void activate() {
        this.config = CCaseConfig.getInstance(this.myProject);
        this.config.setHost(this);
        LOG.info(">>> GetCOnfig().Offline == " + this.config.isOffline());
        if (!this.config.isOffline()) {
            this.resetClearCaseFromConfiguration();
            CCaseViewsManager.getInstance(this.myProject).reloadViews();
        }
        this.listener = new VFSListener(this.getProject());
        LocalFileSystem.getInstance().addVirtualFileListener(this.listener);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this.listener);
        this.addIgnoredFiles();
        if (this.myActivatePolicyCalculateUCM) {
            CCaseSharedConfig sharedConfig = CCaseSharedConfig.getInstance(this.myProject);
            sharedConfig.setUcmMode(Boolean.TRUE.equals(this.myBaseOrUCM.isUCMByRoots()));
        } else {
            this.checkRootsForUCMMismatch();
        }
        this.myActivatePolicyCalculateUCM = false;
        ReadonlyStatusIsVisibleActivationCheck.check((Project)this.myProject, (String)NAME);
    }

    public void checkRootsForUCMMismatch() {
        this.myBaseOrUCM.checkRootsForUCMMismatch();
    }

    public void deactivate() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.listener);
        CommandProcessor.getInstance().removeCommandListener((CommandListener)this.listener);
        ContentRevisionFactory.detachListeners();
    }

    public void offlineModeChanged() {
        if (!this.config.isOffline()) {
            this.modifiedFiles.clear();
        } else {
            ChangeListManager mgr = ChangeListManager.getInstance((Project)this.myProject);
            List list = mgr.getAffectedFiles();
            for (VirtualFile file : list) {
                if (mgr.getStatus(file) != FileStatus.MODIFIED) continue;
                this.modifiedFiles.add(file);
            }
            mgr.scheduleUpdate();
        }
    }

    public void directoryMappingChanged() {
        CCaseViewsManager.getInstance(this.myProject).reloadViews();
    }

    public ClearCase getClearCase() {
        if (this.clearcase == null) {
            this.resetClearCaseFromConfiguration();
        }
        return this.clearcase;
    }

    private void resetClearCaseFromConfiguration() {
        if (this.clearcase == null) {
            CommandLineClearCase cc = new CommandLineClearCase();
            cc.setHost(this);
            this.clearcase = new ClearCaseDecorator(cc);
        }
    }

    private void addIgnoredFiles() {
        String[] sigs;
        String patterns;
        String newPattern = patterns = FileTypeManager.getInstance().getIgnoredFilesList();
        if (patterns.indexOf(CCASE_KEEP_FILE_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_KEEP_FILE_SIG;
        }
        if (patterns.indexOf(CCASE_KEEP_FILE_MID_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_KEEP_FILE_MID_SIG;
        }
        if (patterns.indexOf(CCASE_CONTRIB_FILE_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_CONTRIB_FILE_SIG;
        }
        if (patterns.indexOf(CCASE_CONTRIB_FILE_MID_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_CONTRIB_FILE_MID_SIG;
        }
        if (patterns.indexOf(CCASE_FINDMERGE_FILE_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_FINDMERGE_FILE_SIG;
        }
        if (patterns.indexOf(CCASE_UPDATE_LOG_FILE_SIG) == -1) {
            newPattern = newPattern + (newPattern.charAt(newPattern.length() - 1) == ';' ? "" : ";") + CCASE_UPDATE_LOG_FILE_SIG;
        }
        if (!newPattern.equals(patterns)) {
            final String newPat = newPattern;
            final FileTypeManager mgr = FileTypeManager.getInstance();
            final Runnable action = new Runnable(){

                @Override
                public void run() {
                    mgr.setIgnoredFilesList(newPat);
                }
            };
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            });
        }
        ChangeListManager mgr = ChangeListManager.getInstance((Project)this.getProject());
        for (String sig : sigs = new String[]{CCASE_KEEP_FILE_SIG, CCASE_KEEP_FILE_MID_SIG, CCASE_CONTRIB_FILE_SIG, CCASE_CONTRIB_FILE_MID_SIG, CCASE_FINDMERGE_FILE_SIG, CCASE_UPDATE_LOG_FILE_SIG}) {
            IgnoredFileBean bean = IgnoredBeanFactory.withMask((String)sig);
            mgr.addFilesToIgnore(new IgnoredFileBean[]{bean});
        }
    }

    public boolean fileIsUnderVcs(FilePath path) {
        return VcsUtil.getVcsFor((Project)this.myProject, (FilePath)path) == this;
    }

    public boolean fileIsUnderVcs(String path) {
        return VcsUtil.isFileUnderVcs((Project)this.myProject, (String)path);
    }

    public boolean fileExistsInVcs(FilePath path) {
        if (this.config.isOffline()) {
            return false;
        }
        VirtualFile vfile = path.getVirtualFile();
        if (vfile != null) {
            FileStatus status = FileStatusManager.getInstance((Project)this.myProject).getStatus(vfile);
            if (status == FileStatus.MODIFIED || status == FileStatus.HIJACKED || FileStatus.NOT_CHANGED == status) {
                return true;
            }
            if (status == FileStatus.UNKNOWN || status == FileStatus.ADDED) {
                return false;
            }
            return this.fileExistsInVcs(path.getPath());
        }
        return this.fileExistsInVcs(path.getPath());
    }

    public boolean fileExistsInVcs(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "net/sourceforge/transparent/TransparentVcs", "fileExistsInVcs"));
        }
        boolean exists = false;
        try {
            Status status;
            path = VcsUtil.getCanonicalLocalPath((String)path);
            if (this.renamedFiles.containsKey(path)) {
                path = this.renamedFiles.get(path);
            }
            exists = (status = this.getStatus(new File(path))) != Status.NOT_AN_ELEMENT;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return exists;
    }

    @Override
    public boolean isFileIgnored(VirtualFile file) {
        ChangeListManager mgr = ChangeListManager.getInstance((Project)this.myProject);
        return file != null && mgr.isIgnoredFile(file);
    }

    @Override
    public boolean isRenamedFile(String path) {
        return this.renamedFiles.containsKey(path);
    }

    @Override
    public boolean isRenamedFolder(String path) {
        return this.renamedFolders.containsKey(path);
    }

    @Override
    public boolean isCheckedOutFolder(String path) {
        return this.checkedOutFolders.contains(path);
    }

    public Set<String> getCheckedOutFolders() {
        return this.checkedOutFolders;
    }

    public void folderCheckedOut(String path) {
        this.checkedOutFolders.add(path);
    }

    public void undoCheckout(String path) {
        this.checkedOutFolders.remove(path);
    }

    public boolean isFolderRemoved(String path) {
        return this.removedFolders.contains(path);
    }

    public boolean isFolderRemovedForVcs(String path) {
        return this.deletedFolders.contains(path);
    }

    public boolean isWasRenamed(String path) {
        return this.renamedFiles.containsValue(path);
    }

    public boolean isNewOverRenamed(String path) {
        return this.containsNew(path) && this.isWasRenamed(path);
    }

    public void removeFolderFromDeleted(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "net/sourceforge/transparent/TransparentVcs", "removeFolderFromDeleted"));
        }
        Set<String> folders = this.isFolderRemoved(path) ? this.removedFolders : this.deletedFolders;
        folders.remove(path);
    }

    public void add2NewFiles(Collection<VirtualFile> files) throws VcsException {
        FilterDescendantVirtualFileConvertible filterDescendantVirtualFileConvertible = new FilterDescendantVirtualFileConvertible((Convertor)Convertor.SELF, (Comparator)FilePathComparator.getInstance());
        ArrayList<VirtualFile> highLevel = new ArrayList<VirtualFile>(files);
        filterDescendantVirtualFileConvertible.doFilter(highLevel);
        for (VirtualFile file : highLevel) {
            this.add2NewFile(file);
        }
        this.newFiles.addAll(files);
    }

    public void add2NewFile(VirtualFile file) throws VcsException {
        this.addWithParents(file);
    }

    private void addWithParents(VirtualFile file) throws VcsException {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        VirtualFile vcsRootFor = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(file);
        if (vcsRootFor == null) {
            throw new VcsException("Can not find VCS root for " + file.getPath());
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (this.newFiles.contains(current)) {
                return;
            }
            Status status = this.getStatus(current);
            if (Status.NOT_AN_ELEMENT.equals(status)) {
                this.newFiles.add(current);
                if (current.isDirectory()) {
                    vcsDirtyScopeManager.dirDirtyRecursively(current);
                }
            } else {
                return;
            }
            if (!current.equals(vcsRootFor)) continue;
            return;
        }
    }

    public void deleteNewFile(VirtualFile file) {
        this.newFiles.remove(file);
    }

    public boolean containsNew(VirtualFile file) {
        return this.newFiles.contains(file);
    }

    public boolean containsNew(String path) {
        VirtualFile file = VcsUtil.getVirtualFile((File)new File(path));
        return file != null && this.newFiles.contains(file);
    }

    public boolean containsModified(VirtualFile file) {
        return this.modifiedFiles.contains(file);
    }

    public void add2ModifiedFile(VirtualFile file) {
        this.modifiedFiles.add(file);
    }

    public void clearModifiedList() {
        this.modifiedFiles.clear();
    }

    public boolean containsModified(String path) {
        VirtualFile file = VcsUtil.getVirtualFile((String)path);
        return file != null && this.modifiedFiles.contains(file);
    }

    private boolean isCheckInToUseHijack() {
        return this.config.isOffline() || this.config.checkInUseHijack;
    }

    public Status getStatus(VirtualFile file) {
        return this.getClearCase().getStatus(new File(file.getPath()));
    }

    public Status getStatus(File file) {
        return this.getClearCase().getStatus(file);
    }

    public void checkinFile(FilePath path, String comment, List<VcsException> errors) {
        this.checkinFile(path.getIOFile(), comment, errors);
    }

    public void checkinFile(File ioFile, String comment, List<VcsException> errors) {
        VirtualFile vFile = VcsUtil.getVirtualFile((File)ioFile);
        FileStatusManager fsmgr = FileStatusManager.getInstance((Project)this.myProject);
        try {
            if (vFile != null && fsmgr.getStatus(vFile) == FileStatus.HIJACKED && this.isCheckInToUseHijack()) {
                this.checkoutFile(ioFile, true, comment);
            }
            this.getClearCase().checkIn(ioFile, comment);
        }
        catch (ClearCaseException e) {
            if (TransparentVcs.isMergeConflictMessage(e.getMessage()) && vFile != null) {
                vFile.putUserData(MERGE_CONFLICT, (Object)true);
            }
            TransparentVcs.handleException((Throwable)e, vFile, errors);
        }
        catch (Throwable e) {
            TransparentVcs.handleException(e, vFile, errors);
        }
    }

    public boolean checkoutFile(VirtualFile file, boolean keepHijacked, String comment) throws VcsException {
        File ioFile = new File(file.getPath());
        return this.checkoutFile(ioFile, keepHijacked, comment);
    }

    public void checkoutFile(File file, boolean keepHijacked, String comment, boolean allowCheckedOut, boolean noData) throws VcsException {
        if (this.checkedOutFolders.contains(VcsUtil.getCanonicalLocalPath((String)file.getPath()))) {
            if (!allowCheckedOut) {
                throw new VcsException("File " + file.getPath() + " is already checked out");
            }
            return;
        }
        if (allowCheckedOut) {
            VcsException error = this.tryToCheckout(file, comment, noData);
            if (error != null) {
                throw error;
            }
        } else {
            this.checkoutFile(file, keepHijacked, comment);
        }
    }

    private boolean checkoutFile(File ioFile, boolean keepHijacked, String comment) throws VcsException {
        File newFile = null;
        if (keepHijacked) {
            newFile = new File(ioFile.getParentFile().getAbsolutePath(), ioFile.getName() + HIJACKED_EXT);
            ioFile.renameTo(newFile);
        }
        this.getClearCase().checkOut(ioFile, this.config.checkoutReserved, comment, false);
        if (newFile != null) {
            ioFile.delete();
            newFile.renameTo(ioFile);
        }
        return true;
    }

    public void undoCheckoutFile(VirtualFile vFile, List<VcsException> errors) {
        File ioFile = new File(vFile.getPath());
        this.undoCheckoutFile(vFile, ioFile, errors);
    }

    public void undoCheckoutFile(File file, List<VcsException> errors) {
        this.undoCheckoutFile(null, file, errors);
    }

    private void undoCheckoutFile(VirtualFile vFile, File ioFile, List<VcsException> errors) {
        try {
            this.getClearCase().undoCheckOut(ioFile);
        }
        catch (Throwable e) {
            TransparentVcs.handleException(e, vFile, errors);
        }
    }

    public void addFile(VirtualFile file, @NonNls String comment, List<VcsException> errors) {
        File ioFile = new File(file.getPath());
        File ioParent = ioFile.getParentFile();
        if (ioParent != null) {
            VcsException error;
            String parentComment = TransparentVcs.addToComment(comment, "Adding " + file.getName());
            if (StringUtil.isEmpty((String)comment)) {
                comment = "Initial Checkin";
            }
            if ((error = this.tryToCheckout(ioParent, parentComment, false)) != null) {
                error.setVirtualFile(file);
                errors.add(error);
                return;
            }
            this.addFileToCheckedoutFolder(ioFile, comment, errors);
            try {
                this.getClearCase().checkIn(ioParent, parentComment);
            }
            catch (ClearCaseException ccExc) {
                TransparentVcs.handleException((Throwable)ccExc, file, errors);
            }
        }
    }

    public void addFileToCheckedoutFolder(File ioFile, String comment, List<VcsException> errors) {
        try {
            this.getClearCase().add(ioFile, comment);
            this.getClearCase().checkIn(ioFile, comment);
        }
        catch (ClearCaseException ccExc) {
            TransparentVcs.handleException((Throwable)ccExc, ioFile, errors);
        }
    }

    public void removeFile(final File file, final String comment, final List<VcsException> errors) {
        try {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    File ioParent;
                    Status status = TransparentVcs.this.getFileStatus(file);
                    if (status == Status.CHECKED_OUT) {
                        TransparentVcs.this.undoCheckoutFile(file, (List<VcsException>)errors);
                    }
                    if ((ioParent = file.getParentFile()).exists()) {
                        String deleteComment = "Deleting " + file.getName();
                        String parentComment = TransparentVcs.addToComment(comment, deleteComment);
                        VcsException error = TransparentVcs.this.tryToCheckout(ioParent, parentComment, false);
                        if (error != null) {
                            errors.add(error);
                            return;
                        }
                        try {
                            TransparentVcs.this.getClearCase().delete(file, StringUtil.isNotEmpty((String)comment) ? comment : deleteComment);
                            TransparentVcs.this.getClearCase().checkIn(ioParent, parentComment);
                        }
                        catch (ClearCaseException ccExc) {
                            VcsException e = new VcsException(ccExc.getMessage());
                            errors.add(e);
                        }
                    }
                }
            };
            TransparentVcs.executeAndHandleOtherFileInTheWay(file, action);
        }
        catch (Throwable e) {
            TransparentVcs.handleException(e, (VirtualFile)null, errors);
        }
    }

    public void renameAndCheckInFile(final File oldFile, String newName, String comment, final List<VcsException> errors) {
        final File newFile = new File(oldFile.getParent(), newName);
        try {
            final String modComment = StringUtil.isEmpty((String)comment) ? "Renamed " + oldFile.getName() + " to " + newName : comment;
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    File ioParent = oldFile.getParentFile();
                    if (ioParent.exists()) {
                        TransparentVcs.renameFile(newFile, oldFile);
                        if (!oldFile.isDirectory()) {
                            TransparentVcs.this.checkinFile(oldFile, modComment, (List<VcsException>)errors);
                        }
                        TransparentVcs.this.getClearCase().checkOut(ioParent, ((TransparentVcs)TransparentVcs.this).config.checkoutReserved, modComment, true);
                        TransparentVcs.this.getClearCase().move(oldFile, newFile, modComment);
                        TransparentVcs.this.getClearCase().checkIn(ioParent, modComment);
                    }
                }
            };
            TransparentVcs.executeAndHandleOtherFileInTheWay(oldFile, action);
        }
        catch (Throwable e) {
            TransparentVcs.handleException(e, newFile, errors);
        }
    }

    public void moveRenameAndCheckInFile(String filePath, String newParentPath, String newName, String comment, final List<VcsException> errors) {
        final File oldFile = new File(filePath);
        final File newFile = new File(newParentPath, newName);
        try {
            final String modComment = StringUtil.isEmpty((String)comment) ? "Moved " + filePath + " to " + newName : comment;
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    TransparentVcs.renameFile(newFile, oldFile);
                    if (!oldFile.isDirectory()) {
                        TransparentVcs.this.checkinFile(oldFile, modComment, (List<VcsException>)errors);
                    }
                    if (errors.size() == 0) {
                        try {
                            VcsException error = TransparentVcs.this.tryToCheckout(newFile.getParentFile(), modComment, false);
                            if (error != null) {
                                throw error;
                            }
                            error = TransparentVcs.this.tryToCheckout(oldFile.getParentFile(), modComment, false);
                            if (error != null) {
                                throw error;
                            }
                            TransparentVcs.this.getClearCase().move(oldFile, newFile, modComment);
                            TransparentVcs.this.checkinFile(newFile.getParentFile(), null, (List<VcsException>)errors);
                            TransparentVcs.this.checkinFile(oldFile.getParentFile(), null, (List<VcsException>)errors);
                        }
                        catch (VcsException e) {
                            TransparentVcs.handleException(e, newFile, (List<VcsException>)errors);
                        }
                    }
                }
            };
            TransparentVcs.executeAndHandleOtherFileInTheWay(oldFile, action);
            if (errors.size() > 0) {
                TransparentVcs.renameFile(oldFile, newFile);
            }
        }
        catch (Throwable e) {
            TransparentVcs.handleException(e, newFile, errors);
        }
    }

    private static void executeAndHandleOtherFileInTheWay(File targetFile, Runnable command) {
        if (targetFile.exists()) {
            TransparentVcs.executeWithFileInTheWay(targetFile, command);
        } else {
            command.run();
        }
    }

    private static void executeWithFileInTheWay(File file, Runnable command) {
        File tmpFile = new File(file.getPath() + TEMPORARY_FILE_SUFFIX);
        TransparentVcs.renameFile(file, tmpFile);
        try {
            command.run();
        }
        finally {
            if (!tmpFile.renameTo(file)) {
                throw new ClearCaseException("The file '" + file.getAbsolutePath() + "' has been deleted then re-added\nCheck if there is a file '" + tmpFile.getAbsolutePath() + "' and rename it back manually");
            }
        }
    }

    private static void renameFile(File fileToRename, File newFile) {
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            throw new ClearCaseException("Could not create dir " + newFile.getParentFile().getAbsolutePath() + "\nto move " + fileToRename.getAbsolutePath() + " into");
        }
        if (!fileToRename.renameTo(newFile)) {
            throw new ClearCaseException("Could not move " + fileToRename.getAbsolutePath() + " to " + newFile.getAbsolutePath());
        }
    }

    public void changeActivityForLastVersion(FilePath file, String srcActivity, String dstActivity, List<VcsException> errors) {
        CCaseViewsManager viewsMgr = CCaseViewsManager.getInstance(this.myProject);
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)file);
        String output = TransparentVcs.cleartoolOnLocalPathWithOutput(root.getPath(), "lshistory", "-short", file.getPath());
        String[] lines = LineTokenizer.tokenize((CharSequence)output, (boolean)false);
        if (lines.length > 0) {
            String version = lines[0];
            srcActivity = viewsMgr.getActivityIdName(srcActivity);
            String dstActivityNorm = viewsMgr.getActivityIdName(dstActivity);
            Runner runner = new Runner();
            runner.workingDir = root.getPath();
            runner.run(new String[]{CLEARTOOL_CMD, "lsact", "-short", dstActivityNorm}, true);
            if (!runner.isSuccessfull()) {
                runner.run(new String[]{CLEARTOOL_CMD, "mkact", "-nc", "-f", "-headline", "\"" + dstActivity + "\"", dstActivityNorm}, true);
                if (!runner.isSuccessfull()) {
                    String msg = "Error occured while creating an activity (possibly illegal activity name). File(s) is checked to the default activity.Error description: " + runner.getOutput();
                    errors.add(new VcsException(msg));
                    return;
                }
            }
            runner.run(new String[]{CLEARTOOL_CMD, CHANGE_ACTIVITY_CMD, "-nc", "-fcset", srcActivity, "-tcset", dstActivityNorm, CommandLineClearCase.quote(version)}, true);
            if (!runner.isSuccessfull()) {
                errors.add(new VcsException(runner.getOutput()));
            }
        } else {
            errors.add(new VcsException("Did not manage to retrieve the element version for Activity movement."));
        }
    }

    private VcsException tryToCheckout(File file, String comment, boolean noData) {
        VcsException error;
        block2: {
            error = null;
            try {
                this.getClearCase().checkOut(file, this.config.checkoutReserved, comment, noData);
            }
            catch (ClearCaseException ccExc) {
                String msg = ccExc.getMessage();
                if (msg.indexOf(ALREADY_CHECKEDOUT_SIG) != -1) break block2;
                error = new VcsException(msg);
            }
        }
        return error;
    }

    public Status getFileStatus(VirtualFile file) {
        return this.getFileStatus(new File(file.getPresentableUrl()));
    }

    public Status getFileStatus(File file) {
        return this.getClearCase().getStatus(file);
    }

    public static CheckedOutStatus getCheckedOutStatus(File file) {
        Runner runner = new Runner();
        runner.run(new String[]{CLEARTOOL_CMD, "lscheckout", "-fmt", "%Rf", "-directory", file.getAbsolutePath()}, true);
        if (!runner.isSuccessfull()) {
            return CheckedOutStatus.NOT_CHECKED_OUT;
        }
        if (runner.getOutput().equalsIgnoreCase(RESERVED_SIG)) {
            return CheckedOutStatus.RESERVED;
        }
        if (runner.getOutput().equalsIgnoreCase(UNRESERVED_SIG)) {
            return CheckedOutStatus.UNRESERVED;
        }
        return CheckedOutStatus.NOT_CHECKED_OUT;
    }

    public static String getCheckoutComment(File file) {
        Runner runner = new Runner();
        runner.run(new String[]{CLEARTOOL_CMD, "lscheckout", "-fmt", "%c", "-directory", file.getAbsolutePath()}, true);
        String output = runner.getOutput();
        return !runner.isSuccessfull() || output.indexOf(NOT_A_VOB_OBJECT_SIG) != -1 ? "" : output;
    }

    public static void cleartool(String ... subcmd) throws ClearCaseException {
        String[] cmd = Runner.getCommand(CLEARTOOL_CMD, subcmd);
        LOG.debug("|" + Runner.getCommandLine(cmd));
        try {
            Runner.runAsynchronously(cmd);
        }
        catch (IOException e) {
            throw new ClearCaseException(e.getMessage());
        }
    }

    public static void cleartoolOnLocalPath(String path, String ... subcmd) throws ClearCaseException {
        try {
            String[] cmd = Runner.getCommand(CLEARTOOL_CMD, subcmd);
            Runner.runAsynchronouslyOnPath(path, cmd);
        }
        catch (IOException e) {
            throw new ClearCaseException(e.getMessage());
        }
    }

    public static String cleartoolWithOutput(String ... subcmd) {
        Runner runner = new Runner();
        runner.run(Runner.getCommand(CLEARTOOL_CMD, subcmd), true);
        return runner.getOutput();
    }

    public static String cleartoolOnLocalPathWithOutput(String path, String ... subcmd) throws ClearCaseException {
        Runner runner = new Runner();
        runner.workingDir = path;
        runner.run(Runner.getCommand(CLEARTOOL_CMD, subcmd), true);
        return runner.getOutput();
    }

    private static void handleException(Throwable e, VirtualFile file, List<VcsException> errors) {
        VcsException vcsE = new VcsException(e);
        vcsE.setVirtualFile(file);
        errors.add(vcsE);
    }

    private static void handleException(Throwable e, File file, List<VcsException> errors) {
        VirtualFile vFile = VcsUtil.getVirtualFile((File)file);
        TransparentVcs.handleException(e, vFile, errors);
    }

    private static String addToComment(String comment, @NonNls String addedText) {
        return StringUtil.isNotEmpty((String)comment) ? comment + '\n' + addedText : addedText;
    }

    public static boolean isServerDownMessage(String msg) {
        String msgSig1 = "albd_contact call failed";
        String msgSig2 = "Unable to connect albd_server";
        String msgSig3 = "can not contact license server";
        return msg != null && (msg.indexOf("albd_contact call failed") != -1 || msg.indexOf("Unable to connect albd_server") != -1 || msg.indexOf("can not contact license server") != -1);
    }

    private static boolean isMergeConflictMessage(String msg) {
        String msgSig1 = "he most recent version";
        String msgSig2 = "is not the predecessor of this";
        return msg != null && msg.indexOf("he most recent version") != -1 && msg.indexOf("is not the predecessor of this") != -1;
    }

    public void readExternal(Element element) throws InvalidDataException {
        com.intellij.util.containers.HashSet tmp = new com.intellij.util.containers.HashSet();
        TransparentVcs.readElements(element, this.removedFiles, PERSISTENCY_REMOVED_FILE_TAG, false);
        TransparentVcs.readElements(element, this.removedFolders, PERSISTENCY_REMOVED_FOLDER_TAG, false);
        TransparentVcs.readElements(element, this.deletedFiles, PERSISTENCY_DELETED_FILE_TAG, false);
        TransparentVcs.readElements(element, this.deletedFolders, PERSISTENCY_DELETED_FOLDER_TAG, false);
        TransparentVcs.readElements(element, (Set<String>)tmp, PERSISTENCY_NEW_FILE_TAG, true);
        TransparentVcs.convertStringSet2VFileSet((Set<String>)tmp, this.newFiles);
        TransparentVcs.readElements(element, (Set<String>)tmp, PERSISTENCY_MODIFIED_FILE_TAG, true);
        TransparentVcs.convertStringSet2VFileSet((Set<String>)tmp, this.modifiedFiles);
        TransparentVcs.readRenamedElements(element, this.renamedFiles, PERSISTENCY_RENAMED_FILE_TAG, true);
        TransparentVcs.readRenamedElements(element, this.renamedFolders, PERSISTENCY_RENAMED_FOLDER_TAG, true);
        TransparentVcs.readElements(element, this.checkedOutFolders, PERSISTENCY_CHECKED_OUT_FOLDER_TAG, true);
    }

    private static void convertStringSet2VFileSet(Set<String> set, Set<VirtualFile> vSet) {
        vSet.clear();
        for (String path : set) {
            VirtualFile file = VcsUtil.getVirtualFile((String)path);
            if (file == null) continue;
            vSet.add(file);
        }
    }

    private static void readElements(Element element, Set<String> list, String tag, boolean isExist) {
        List files = element.getChildren(tag);
        for (Object cclObj : files) {
            Element currentCLElement;
            String path;
            if (!(cclObj instanceof Element) || new File(path = (currentCLElement = (Element)cclObj).getValue()).exists() != isExist) continue;
            list.add(path);
        }
    }

    public static void readRenamedElements(Element element, Map<String, String> list, String tag, boolean isExist) {
        List files = element.getChildren(tag);
        for (Object cclObj : files) {
            Element currentCLElement;
            String pathPair;
            int delimIndex;
            if (!(cclObj instanceof Element) || (delimIndex = (pathPair = (currentCLElement = (Element)cclObj).getValue()).indexOf(PATH_DELIMITER)) == -1) continue;
            String newName = pathPair.substring(0, delimIndex);
            String oldName = pathPair.substring(delimIndex + PATH_DELIMITER.length());
            if (new File(newName).exists() != isExist) continue;
            list.put(newName, oldName);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        FileStatus status;
        TransparentVcs.writeElement(element, this.removedFiles, PERSISTENCY_REMOVED_FILE_TAG);
        TransparentVcs.writeElement(element, this.removedFolders, PERSISTENCY_REMOVED_FOLDER_TAG);
        TransparentVcs.writeElement(element, this.deletedFiles, PERSISTENCY_DELETED_FILE_TAG);
        TransparentVcs.writeElement(element, this.deletedFolders, PERSISTENCY_DELETED_FOLDER_TAG);
        com.intellij.util.containers.HashSet tmp = new com.intellij.util.containers.HashSet();
        for (VirtualFile file : this.newFiles) {
            status = FileStatusManager.getInstance((Project)this.myProject).getStatus(file);
            if (status != FileStatus.ADDED) continue;
            tmp.add((Object)file.getPath());
        }
        TransparentVcs.writeElement(element, (Set<String>)tmp, PERSISTENCY_NEW_FILE_TAG);
        for (VirtualFile file : this.modifiedFiles) {
            status = FileStatusManager.getInstance((Project)this.myProject).getStatus(file);
            if (status != FileStatus.MODIFIED) continue;
            tmp.add((Object)file.getPath());
        }
        TransparentVcs.writeElement(element, (Set<String>)tmp, PERSISTENCY_MODIFIED_FILE_TAG);
        TransparentVcs.writePairedElement(element, this.renamedFiles, PERSISTENCY_RENAMED_FILE_TAG);
        TransparentVcs.writePairedElement(element, this.renamedFolders, PERSISTENCY_RENAMED_FOLDER_TAG);
        TransparentVcs.writeElement(element, this.checkedOutFolders, PERSISTENCY_CHECKED_OUT_FOLDER_TAG);
    }

    private static void writeElement(Element element, Set<String> files, String tag) {
        Object[] sorted = ArrayUtil.toStringArray(files);
        Arrays.sort(sorted);
        for (Object file : sorted) {
            Element listElement = new Element(tag);
            listElement.addContent((String)file);
            element.addContent(listElement);
        }
    }

    public static void writePairedElement(Element element, Map<String, String> files, String tag) {
        for (String file : files.keySet()) {
            Element listElement = new Element(tag);
            String pathPair = file.concat(PATH_DELIMITER).concat(files.get(file));
            listElement.addContent(pathPair);
            element.addContent(listElement);
        }
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public void enableIntegration() {
        super.enableIntegration();
        this.myActivatePolicyCalculateUCM = true;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public void reportAdded(VirtualFile dir, Collection<VirtualFile> addTo) {
        for (VirtualFile newFile : this.newFiles) {
            if (newFile == null || !newFile.isValid() || !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)newFile, (boolean)false)) continue;
            addTo.add(newFile);
        }
    }

    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    public Status getStatusSafely(VirtualFile file) {
        try {
            return this.getStatus(file);
        }
        catch (ClearCaseException e) {
            return Status.NOT_AN_ELEMENT;
        }
    }

    public Status getStatusSafely(File file) {
        try {
            return this.getClearCase().getStatus(file);
        }
        catch (ClearCaseException e) {
            return Status.NOT_AN_ELEMENT;
        }
    }

    public String discoverNewName(String oldName) {
        String canonicName = VcsUtil.getCanonicalLocalPath((String)oldName);
        if (this.renamedFiles.containsValue(canonicName)) {
            for (Map.Entry<String, String> entry : this.renamedFiles.entrySet()) {
                if (!Comparing.equal((String)entry.getValue(), (String)canonicName)) continue;
                return entry.getKey();
            }
        } else {
            for (Map.Entry<String, String> entry : this.renamedFolders.entrySet()) {
                if (!canonicName.startsWith(entry.getValue())) continue;
                return entry.getKey() + canonicName.substring(entry.getValue().length());
            }
        }
        return oldName;
    }

    public String discoverOldName(String file) {
        String canonicName = VcsUtil.getCanonicalLocalPath((String)file);
        String oldName = this.renamedFiles.get(canonicName);
        if (oldName == null && (oldName = this.renamedFolders.get(canonicName)) == null) {
            oldName = this.findInRenamedParentFolder(file);
            if (oldName == null) {
                oldName = file;
            } else {
                String checkRenamed = this.renamedFiles.get(oldName);
                if (checkRenamed != null) {
                    oldName = checkRenamed;
                }
            }
        }
        return oldName;
    }

    private String findInRenamedParentFolder(String name) {
        String fileInOldFolder = name;
        for (String folder : this.renamedFolders.keySet()) {
            String oldFolderName = this.renamedFolders.get(folder);
            if (!name.startsWith(folder)) continue;
            fileInOldFolder = oldFolderName + name.substring(folder.length());
            break;
        }
        return fileInOldFolder;
    }
}

