/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.process.ProcessCloseUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;

public class Runner {
    private static final Logger LOG = Logger.getInstance((String)"#net.sourceforge.transparent.Runner");
    private static final boolean DEBUG = false;
    private boolean successfull;
    public String workingDir = null;
    private String myOutput;

    private Process createProcess(String[] command) throws IOException {
        String cmdLine = Runner.getCommandLine(command);
        if (this.workingDir == null) {
            return Runtime.getRuntime().exec(command);
        }
        File wrkDir = new File(this.workingDir);
        if (!wrkDir.exists() || !wrkDir.isDirectory()) {
            throw new IOException("Path " + this.workingDir + " is not a valid working directory for a command: " + cmdLine);
        }
        return Runtime.getRuntime().exec(command, null, wrkDir);
    }

    public static String getCommandLine(String[] command) {
        StringBuilder buf = new StringBuilder();
        for (String aCommand : command) {
            buf.append(aCommand).append(" ");
        }
        return buf.toString();
    }

    private static String consumeProcessOutputs(Process process) throws InterruptedException {
        Consumer outputConsumer = new Consumer(process.getInputStream());
        Consumer errorConsumer = new Consumer(process.getErrorStream());
        Future errorDone = ApplicationManager.getApplication().executeOnPooledThread((Runnable)errorConsumer);
        outputConsumer.run();
        try {
            errorDone.get();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        StringBuilder out = outputConsumer.get_buffer();
        StringBuilder error = errorConsumer.get_buffer();
        if (error.length() > 0) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append((CharSequence)error);
        }
        return out.toString();
    }

    public static void runAsynchronously(String command) throws IOException {
        Runtime.getRuntime().exec(command);
    }

    public static void runAsynchronously(String[] command) throws IOException {
        Runtime.getRuntime().exec(command);
    }

    public static void runAsynchronouslyOnPath(String path, String[] command) throws IOException {
        Runtime.getRuntime().exec(command, null, new File(path));
    }

    public void run(String command) {
        this.run(command, false);
    }

    public void run(String[] command) {
        this.run(command, false);
    }

    public boolean run(String command, boolean canFail) {
        return this.run(new String[]{command}, canFail);
    }

    public boolean run(String[] command, boolean canFail) {
        LOG.info("|" + Runner.getCommandLine(command));
        try {
            this.successfull = this.execProcess(command);
            if (this.successfull) {
                return true;
            }
            if (!canFail) {
                throw new ClearCaseException("Error executing " + Runner.getCommandLine(command) + " : " + this.myOutput);
            }
            return false;
        }
        catch (RuntimeException e) {
            if (StringUtil.isNotEmpty((String)this.workingDir)) {
                LOG.info("CCAse runtime exception (started in [" + this.workingDir + "]: " + e.getMessage(), (Throwable)e);
            } else {
                LOG.info("CCAse runtime exception :" + e.getMessage(), (Throwable)e);
            }
            throw new ClearCaseException(e.getMessage());
        }
        catch (Exception e) {
            if (StringUtil.isNotEmpty((String)this.workingDir)) {
                LOG.info("CCAse exception: (started in [" + this.workingDir + "]: " + e.getMessage(), (Throwable)e);
            } else {
                LOG.info("CCAse exception: " + e.getMessage(), (Throwable)e);
            }
            throw new ClearCaseException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execProcess(String[] command) throws IOException, InterruptedException {
        Process process = this.createProcess(command);
        try {
            this.myOutput = Runner.consumeProcessOutputs(process);
            int retCode = process.waitFor();
            boolean bl = retCode == 0;
            return bl;
        }
        finally {
            ProcessCloseUtil.close((Process)process);
        }
    }

    public String getOutput() {
        return this.myOutput;
    }

    public boolean isSuccessfull() {
        return this.successfull;
    }

    public static String[] getCommand(@NonNls String exec, String[] args) {
        String[] cmd = new String[args.length + 1];
        cmd[0] = exec;
        System.arraycopy(args, 0, cmd, 1, args.length);
        return cmd;
    }

    private static class Consumer
    implements Runnable {
        private final StringBuilder _buffer = new StringBuilder();
        private final BufferedReader _reader;

        public Consumer(InputStream inputStream) {
            this._reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this._reader.readLine()) != null) {
                    if (this._buffer.length() != 0) {
                        this._buffer.append("\n");
                    }
                    this._buffer.append(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public StringBuilder get_buffer() {
            return this._buffer;
        }
    }
}

