/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.History;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import net.sourceforge.transparent.History.CCaseFileRevision;
import net.sourceforge.transparent.History.CCaseHistoryParser;
import net.sourceforge.transparent.History.CCaseRevisionNumber;
import net.sourceforge.transparent.StatusMultipleProcessor;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseHistoryProvider
implements VcsHistoryProvider,
VcsCacheableHistorySessionFactory<Boolean, CCaseHistorySession> {
    @NonNls
    private static final String HISTORY_CMD = "lshistory";
    @NonNls
    private static final String LIMITED_SWITCH = "-last";
    @NonNls
    private static final String CCASE_DATE_COLUMN = "ClearCase Date";
    @NonNls
    private static final String ACTION_COLUMN = "Action";
    @NonNls
    private static final String LABEL_COLUMN = "Label";
    @NonNls
    private static final String NOT_A_VOB_OBJECT = "Not a vob object";
    private final Project project;
    private final TransparentVcs host;
    private static final ColumnInfo<VcsFileRevision, String> CCASE_DATE = new ColumnInfo<VcsFileRevision, String>("ClearCase Date"){

        public String valueOf(VcsFileRevision revision) {
            if (!(revision instanceof CCaseFileRevision)) {
                return "";
            }
            return ((CCaseFileRevision)revision).getChangeCcaseDate();
        }

        public Comparator<VcsFileRevision> getComparator() {
            return new Comparator<VcsFileRevision>(){

                @Override
                public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                    if (!(o1 instanceof CCaseFileRevision)) {
                        return 0;
                    }
                    if (!(o2 instanceof CCaseFileRevision)) {
                        return 0;
                    }
                    CCaseFileRevision cO1 = (CCaseFileRevision)o1;
                    CCaseFileRevision cO2 = (CCaseFileRevision)o2;
                    if (cO1.getOrder() < cO2.getOrder()) {
                        return -1;
                    }
                    if (cO1.getOrder() > cO2.getOrder()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> ACTION = new ColumnInfo<VcsFileRevision, String>("Action"){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof CCaseFileRevision)) {
                return "";
            }
            return ((CCaseFileRevision)vcsFileRevision).getAction();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> LABEL = new ColumnInfo<VcsFileRevision, String>("Label"){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof CCaseFileRevision)) {
                return "";
            }
            return ((CCaseFileRevision)vcsFileRevision).getLabels();
        }
    };

    public CCaseHistoryProvider(Project project) {
        this.project = project;
        this.host = TransparentVcs.getInstance(project);
    }

    public boolean isDateOmittable() {
        return true;
    }

    @NonNls
    @Nullable
    public String getHelpId() {
        return null;
    }

    public boolean supportsHistoryForDirectories() {
        return false;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return null;
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "net/sourceforge/transparent/History/CCaseHistoryProvider", "canShowHistoryFor"));
        }
        return true;
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return AnAction.EMPTY_ARRAY;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])new ColumnInfo[]{CCASE_DATE, ACTION, LABEL});
    }

    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        FileStatus status;
        VirtualFile vfile;
        String path = filePath.getPath();
        if (this.host.renamedFiles.containsKey(path)) {
            path = this.host.renamedFiles.get(path);
        }
        if ((vfile = filePath.getVirtualFile()) != null && (status = FileStatusManager.getInstance((Project)this.project).getStatus(vfile)) == FileStatus.HIJACKED) {
            path = path + "@@";
        }
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(HISTORY_CMD);
        if (this.host.getConfig().isHistoryResticted) {
            int margin = this.host.getConfig().getHistoryRevisionsMargin();
            commandParts.add(LIMITED_SWITCH);
            commandParts.add(String.valueOf(margin));
        }
        CCaseHistoryParser.fillParametersTail(commandParts);
        commandParts.add(path);
        String log = TransparentVcs.cleartoolWithOutput(ArrayUtil.toStringArray(commandParts));
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        if (log.contains(NOT_A_VOB_OBJECT)) {
            throw new VcsException(log);
        }
        ArrayList<CCaseHistoryParser.SubmissionData> changes = CCaseHistoryParser.parse(log);
        for (CCaseHistoryParser.SubmissionData change : changes) {
            try {
                CCaseFileRevision rev = new CCaseFileRevision(change, path, this.project);
                revisions.add(rev);
            }
            catch (NullPointerException e) {
                TransparentVcs.LOG.info("Can not parse history record, found intermediate record.");
            }
        }
        return new CCaseHistorySession(revisions, filePath);
    }

    public static void historyGetter(Project project, FilePath filePath, int maxCnt, Consumer<CCaseHistoryParser.SubmissionData> consumer) throws VcsException {
        FileStatus status;
        VirtualFile vfile;
        TransparentVcs host = TransparentVcs.getInstance(project);
        String path = filePath.getPath();
        if (host.renamedFiles.containsKey(path)) {
            path = host.renamedFiles.get(path);
        }
        if ((vfile = filePath.getVirtualFile()) != null && (status = FileStatusManager.getInstance((Project)project).getStatus(vfile)) == FileStatus.HIJACKED) {
            path = path + "@@";
        }
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(HISTORY_CMD);
        if (maxCnt > 0) {
            commandParts.add(LIMITED_SWITCH);
            commandParts.add(String.valueOf(maxCnt));
        } else if (host.getConfig().isHistoryResticted) {
            int margin = host.getConfig().getHistoryRevisionsMargin();
            commandParts.add(LIMITED_SWITCH);
            commandParts.add(String.valueOf(margin));
        }
        CCaseHistoryParser.fillParametersTail(commandParts);
        commandParts.add(path);
        String log = TransparentVcs.cleartoolWithOutput(ArrayUtil.toStringArray(commandParts));
        if (log.contains(NOT_A_VOB_OBJECT)) {
            throw new VcsException(log);
        }
        ArrayList<CCaseHistoryParser.SubmissionData> changes = CCaseHistoryParser.parse(log);
        for (CCaseHistoryParser.SubmissionData change : changes) {
            consumer.consume((Object)change);
        }
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsHistorySession session = this.createSessionFor(path);
        partner.reportCreatedEmptySession((VcsAbstractHistorySession)session);
    }

    public FilePath getUsedFilePath(CCaseHistorySession session) {
        return null;
    }

    public Boolean getAddinionallyCachedData(CCaseHistorySession session) {
        return null;
    }

    public CCaseHistorySession createFromCachedData(@Nullable Boolean aBoolean, @NotNull List<VcsFileRevision> revisions, @NotNull FilePath filePath, @Nullable VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "net/sourceforge/transparent/History/CCaseHistoryProvider", "createFromCachedData"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "net/sourceforge/transparent/History/CCaseHistoryProvider", "createFromCachedData"));
        }
        return new CCaseHistorySession(revisions, filePath);
    }

    static class CCaseHistorySession
    extends VcsAbstractHistorySession {
        private final FilePath myPath;

        public CCaseHistorySession(List<VcsFileRevision> revs, FilePath path) {
            super(revs, CCaseHistorySession.currentRevisionImpl(path, revs));
            this.myPath = path;
        }

        public boolean isContentAvailable(VcsFileRevision revision) {
            return revision instanceof CCaseFileRevision && !"create branch".equals(((CCaseFileRevision)revision).getAction()) && !"create file element".equals(((CCaseFileRevision)revision).getAction());
        }

        protected VcsRevisionNumber calcCurrentRevisionNumber() {
            return CCaseHistorySession.currentRevisionImpl(this.myPath, this.getRevisionList());
        }

        private static VcsRevisionNumber currentRevisionImpl(FilePath filePath, List<VcsFileRevision> list) {
            VcsRevisionNumber revision;
            String currentRevision = StatusMultipleProcessor.getCurrentRevision(filePath.getPath());
            if (currentRevision != null) {
                for (VcsFileRevision revision2 : list) {
                    if (!revision2.getRevisionNumber().asString().equals(currentRevision)) continue;
                    return revision2.getRevisionNumber();
                }
                return new CCaseRevisionNumber(currentRevision, 0);
            }
            try {
                int maxRevision = 0;
                for (VcsFileRevision rev : list) {
                    maxRevision = Math.max(maxRevision, ((CCaseFileRevision)rev).getOrder());
                }
                revision = new VcsRevisionNumber.Int(maxRevision);
            }
            catch (Exception e) {
                revision = VcsRevisionNumber.NULL;
            }
            return revision;
        }

        public boolean isCurrentRevision(VcsRevisionNumber rev) {
            VcsRevisionNumber cachedRevision = this.getCachedRevision();
            return cachedRevision != null && cachedRevision.asString().equals(rev.asString());
        }

        public HistoryAsTreeProvider getHistoryAsTreeProvider() {
            return null;
        }

        public VcsHistorySession copy() {
            return new CCaseHistorySession(this.getRevisionList(), this.myPath);
        }
    }
}

