/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.History;

import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseHistoryParser {
    @NonNls
    public static final String BRANCH_COMMAND_SIG = "create branch";
    @NonNls
    public static final String CREATE_ELEM_COMMAND_SIG = "create file element";
    @NonNls
    private static final String VERSION_DELIM = "@@";
    @NonNls
    private static final String[] actions = new String[]{"create file element", "create branch", "create version", "checkin version"};
    private static final String FMT = "-fmt";
    private static final Field[] ourFields = new Field[]{new Field(0, "\\\"", "\"", "%d"){

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.createNext();
            data.changeDate = value == null ? "" : value;
        }
    }, new Field(1, "\\\"", "\"", "%Fu"){

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.getCurrent();
            data.submitter = value == null ? "" : value;
        }
    }, new Field(2, "\\\"", "\"", "%e"){

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.getCurrent();
            data.action = value == null ? "" : value;
        }
    }, new Field(3, "\\\"", "\"", "%l"){

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.getCurrent();
            data.labels = value == null ? "" : value;
        }
    }, new Field(4, "\\\"", "\"", "%n"){

        @Override
        protected String parseImpl(String s) {
            String parsed = super.parseImpl(s);
            int idx = parsed.indexOf(CCaseHistoryParser.VERSION_DELIM);
            if (idx != -1) {
                return parsed.substring(idx);
            }
            return "";
        }

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.getCurrent();
            if (data.version != null) {
                data = iterator.createNext();
            }
            data.version = value == null ? "" : value;
        }
    }, new Field(5, "\\\"", "\"", "%Nc"){

        @Override
        public void parse(String s, CreatingIterator iterator) {
            super.parse(s, iterator);
        }

        @Override
        protected void fill(@Nullable String value, CreatingIterator iterator) {
            SubmissionData data = iterator.getCurrent();
            if (value != null) {
                data.comment = data.comment == null ? value : data.comment + '\n' + value;
            }
        }
    }};

    private CCaseHistoryParser() {
    }

    public static ArrayList<SubmissionData> parse(String content) {
        String[] lines = LineTokenizer.tokenize((CharSequence)content, (boolean)false);
        LogParseResult resultHolder = new LogParseResult();
        FieldsDetector detector = new FieldsDetector();
        for (String line : lines) {
            Field field = detector.guess(line);
            if (field != null) {
                field.parse(line, resultHolder);
                continue;
            }
            Field defaultField = detector.defaultField();
            if (defaultField == null) continue;
            defaultField.fill(line, resultHolder);
        }
        return resultHolder.getResult();
    }

    public static void fillParametersVersionOnly(List<String> list) {
        list.add(FMT);
        StringBuilder sb = new StringBuilder();
        ourFields[4].append(sb);
        list.add(sb.toString());
    }

    public static void fillParametersTail(List<String> list) {
        list.add(FMT);
        StringBuilder sb = new StringBuilder();
        for (Field field : ourFields) {
            field.append(sb);
        }
        list.add(sb.toString());
    }

    private static class LogParseResult
    implements CreatingIterator {
        private final ArrayList<SubmissionData> myResult = new ArrayList();

        private LogParseResult() {
        }

        @Override
        @NotNull
        public SubmissionData getCurrent() {
            if (this.myResult.isEmpty()) {
                this.myResult.add(new SubmissionData(this.myResult.size()));
            }
            SubmissionData submissionData = this.myResult.get(this.myResult.size() - 1);
            if (submissionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/History/CCaseHistoryParser$LogParseResult", "getCurrent"));
            }
            return submissionData;
        }

        @Override
        @NotNull
        public SubmissionData createNext() {
            this.myResult.add(new SubmissionData(this.myResult.size()));
            SubmissionData submissionData = this.myResult.get(this.myResult.size() - 1);
            if (submissionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/History/CCaseHistoryParser$LogParseResult", "createNext"));
            }
            return submissionData;
        }

        public ArrayList<SubmissionData> getResult() {
            return this.myResult;
        }
    }

    private static interface CreatingIterator {
        @NotNull
        public SubmissionData getCurrent();

        @NotNull
        public SubmissionData createNext();
    }

    private static abstract class Field {
        private final int myNum;
        private final String myText;
        private static final String myMagic = "\u0001";

        public Field(int num, String writeWrapper, String readWrapper, String text) {
            this.myNum = num;
            this.myText = text;
        }

        public void append(StringBuilder sb) {
            sb.append(this.myNum);
            sb.append(myMagic);
            sb.append(this.myText);
            sb.append('\n');
        }

        public boolean acceptString(String s) {
            return StringUtil.startsWithConcatenation((String)s, (String[])new String[]{String.valueOf(this.myNum), myMagic});
        }

        protected abstract void fill(@Nullable String var1, CreatingIterator var2);

        @Nullable
        protected String parseImpl(String s) {
            if (this.acceptString(s)) {
                String result = s.substring(2);
                return result;
            }
            return null;
        }

        public void parse(String s, CreatingIterator iterator) {
            this.fill(this.parseImpl(s), iterator);
        }
    }

    private static class FieldsDetector {
        private int myRecentIdx = 0;

        private FieldsDetector() {
        }

        @Nullable
        public Field guess(String line) {
            int guessIdx;
            int n = guessIdx = this.myRecentIdx + 1 == ourFields.length ? 0 : this.myRecentIdx + 1;
            if (ourFields[guessIdx].acceptString(line)) {
                this.myRecentIdx = guessIdx;
                return ourFields[guessIdx];
            }
            for (int i = 0; i < ourFields.length; ++i) {
                Field field = ourFields[i];
                if (!field.acceptString(line)) continue;
                this.myRecentIdx = i;
                return field;
            }
            return null;
        }

        @Nullable
        public Field defaultField() {
            int oldRecentIdx = this.myRecentIdx;
            if (ourFields[oldRecentIdx].myNum == 5) {
                this.myRecentIdx = oldRecentIdx;
                return ourFields[oldRecentIdx];
            }
            return null;
        }
    }

    public static class SubmissionData {
        public String action;
        public String version;
        public String submitter;
        public String changeDate;
        public String comment;
        public String labels;
        public int order;

        public SubmissionData(int order) {
            this.order = order;
        }
    }
}

