/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.History;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.ChangeManagement.CCaseContentRevision;
import net.sourceforge.transparent.History.CCaseHistoryParser;
import net.sourceforge.transparent.History.CCaseHistoryProvider;
import net.sourceforge.transparent.History.CCaseRevisionNumber;
import net.sourceforge.transparent.StatusMultipleProcessor;
import org.jetbrains.annotations.NotNull;

public class CCaseDiffProvider
implements DiffProvider {
    @NotNull
    private final Project myProject;

    public CCaseDiffProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "net/sourceforge/transparent/History/CCaseDiffProvider", "<init>"));
        }
        this.myProject = project;
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        String currentRevision = StatusMultipleProcessor.getCurrentRevision(file.getPath());
        return currentRevision == null ? VcsRevisionNumber.NULL : new CCaseRevisionNumber(currentRevision, 0);
    }

    public ItemLatestState getLastRevision(VirtualFile virtualFile) {
        final String[] result = new String[1];
        try {
            CCaseHistoryProvider.historyGetter(this.myProject, VcsUtil.getFilePath((VirtualFile)virtualFile), 1, new Consumer<CCaseHistoryParser.SubmissionData>(){

                public void consume(CCaseHistoryParser.SubmissionData submissionData) {
                    if (submissionData != null) {
                        result[0] = submissionData.version;
                    }
                }
            });
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(e, "Get last revision of " + virtualFile.getPath() + " failed.");
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
        return new ItemLatestState((VcsRevisionNumber)new CCaseRevisionNumber(result[0], 0), true, false);
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        VirtualFile vf = filePath.getVirtualFile();
        if (vf == null) {
            vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (vf == null) {
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
        return this.getLastRevision(vf);
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        return new CCaseContentRevision(VcsUtil.getFilePath((VirtualFile)selectedFile), this.myProject, revisionNumber.asString());
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }
}

