/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.vcsUtil.FilesProgress;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.CheckoutDialog;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CCaseEditFileProvider
implements EditFileProvider {
    @NonNls
    private static final String REQUEST_TEXT = "Would you like to invoke 'CheckOut' command?";
    @NonNls
    private static final String FAIL_RO_TEXT = "Can not set R/O attribute for file: ";
    @NonNls
    private static final String FAIL_DIALOG_TITLE = "Operation Failed";
    private final TransparentVcs host;

    public CCaseEditFileProvider(TransparentVcs host) {
        this.host = host;
    }

    public String getRequestText() {
        return REQUEST_TEXT;
    }

    public void editFiles(final VirtualFile[] files) throws VcsException {
        final ArrayList errors = new ArrayList();
        final ChangeListManager mgr = ChangeListManager.getInstance((Project)this.host.getProject());
        final CurrentStatusHelper[] statusHelper = new CurrentStatusHelper[1];
        boolean succeeded = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                statusHelper[0] = CCaseEditFileProvider.this.preProcessFiles(files);
            }
        }, "ClearCase checkout: preprocessing files", true, this.host.getProject());
        if (!succeeded || statusHelper[0] == null) {
            return;
        }
        final String comment = this.getEditComment(files, statusHelper[0]);
        if (comment == null) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                int cnt = 0;
                for (VirtualFile file : files) {
                    boolean ignoredFile = mgr.isIgnoredFile(file);
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        indicator.checkCanceled();
                        indicator.setText2((ignoredFile ? "Ignored: " : "Checking out: ") + CCaseEditFileProvider.getFileDescriptionForProgress(file));
                        indicator.setFraction((double)cnt / (double)files.length);
                    }
                    ++cnt;
                    if (ignoredFile) continue;
                    try {
                        statusHelper[0].checkOutOrHijackFile(file, errors, comment);
                    }
                    catch (VcsException e) {
                        return;
                    }
                }
            }
        }, "Checkout files", true, this.host.getProject());
        if (errors.size() > 0) {
            throw (VcsException)((Object)errors.get(0));
        }
    }

    private static String getFileDescriptionForProgress(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return file.getName() + " (" + (parent == null ? file.getPath() : parent.getPath()) + ")";
    }

    @Nullable
    private String getEditComment(VirtualFile[] files, CurrentStatusHelper statusHelper) {
        CCaseViewsManager mgr = CCaseViewsManager.getInstance(this.host.getProject());
        boolean askComment = this.host.getCheckoutOptions().getValue();
        if (!askComment && CCaseSharedConfig.getInstance(this.host.getProject()).isUseUcmModel()) {
            for (VirtualFile file : files) {
                if (statusHelper.shouldHijack(file)) continue;
                boolean isUcmView = mgr.isUcmViewForFile(file);
                boolean hasActivity = mgr.getActivityOfViewOfFile(file) != null;
                boolean bl = askComment = isUcmView && !hasActivity;
                if (askComment) break;
            }
        }
        String comment = "";
        if (askComment) {
            CheckoutDialog dialog = files.length == 1 ? new CheckoutDialog(this.host.getProject(), files[0]) : new CheckoutDialog(this.host.getProject(), files);
            dialog.show();
            if (dialog.getExitCode() == 1) {
                return null;
            }
            comment = dialog.getComment();
        }
        if (!StringUtil.isEmptyOrSpaces((String)comment)) {
            VcsConfiguration.getInstance((Project)this.host.getProject()).saveCommitMessage(comment);
        }
        return comment;
    }

    public static void hijackFile(final VirtualFile file) throws VcsException {
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file, (boolean)false);
                        }
                        catch (IOException e) {
                            Messages.showErrorDialog((String)(CCaseEditFileProvider.FAIL_RO_TEXT + file.getPath()), (String)CCaseEditFileProvider.FAIL_DIALOG_TITLE);
                        }
                    }
                });
            }
        });
    }

    private CurrentStatusHelper preProcessFiles(VirtualFile[] files) {
        CurrentStatusHelper csh = new CurrentStatusHelper(this.host);
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setIndeterminate(false);
        }
        FilesProgress filesProgress = new FilesProgress((double)files.length, "");
        for (VirtualFile file : files) {
            filesProgress.updateIndicator(file);
            String oldName = this.host.discoverOldName(file.getPath());
            if (oldName != null) {
                csh.addRenamed(file, oldName);
                if (this.host.getConfig().isOffline()) {
                    csh.shouldHijack(file);
                    continue;
                }
                Status oldStatus = this.host.getStatusSafely(new File(oldName));
                if (!Status.NOT_AN_ELEMENT.equals(oldStatus)) continue;
                csh.shouldHijack(file);
                continue;
            }
            if (!this.shouldHijackFile(file)) continue;
            csh.shouldHijack(file);
        }
        return csh;
    }

    private boolean shouldHijackFile(VirtualFile file) {
        return this.host.getConfig().isOffline() || this.host.getStatus(file) == Status.NOT_AN_ELEMENT;
    }

    private static class CurrentStatusHelper {
        private final Map<VirtualFile, String> myRenamedMap;
        private final Set<VirtualFile> myShouldHijackFiles;
        private final TransparentVcs host;

        CurrentStatusHelper(TransparentVcs host) {
            this.host = host;
            this.myRenamedMap = new HashMap<VirtualFile, String>();
            this.myShouldHijackFiles = new HashSet<VirtualFile>();
        }

        public void addRenamed(VirtualFile file, String oldName) {
            this.myRenamedMap.put(file, oldName);
        }

        public void unversioned(VirtualFile file) {
            this.myShouldHijackFiles.add(file);
        }

        public String getOldName(VirtualFile file) {
            return this.myRenamedMap.get(file);
        }

        public boolean shouldHijack(VirtualFile file) {
            return this.myShouldHijackFiles.contains(file);
        }

        public void checkOutOrHijackFile(VirtualFile file, List<VcsException> errors, String comment) throws VcsException {
            boolean toHijack = this.shouldHijack(file);
            try {
                if (toHijack) {
                    CCaseEditFileProvider.hijackFile(file);
                } else {
                    String oldName = this.myRenamedMap.get(file);
                    if (oldName != null && !file.getPath().equals(FileUtil.toSystemIndependentName((String)oldName))) {
                        File oldFile = new File(oldName);
                        this.host.checkoutFile(oldFile, false, comment, true, true);
                        CCaseEditFileProvider.hijackFile(file);
                    } else {
                        this.host.checkoutFile(file, false, comment);
                    }
                }
            }
            catch (Throwable e) {
                VcsException e1 = new VcsException(e.getMessage());
                errors.add(e1);
                throw e1;
            }
        }
    }
}

