/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringSecurityRolePsiReferenceProvider
extends PsiReferenceProvider {
    private final boolean tokenize;
    private final boolean includePredefinedRoles;

    protected SpringSecurityRolePsiReferenceProvider(boolean tokenize, boolean includePredefinedRoles) {
        this.tokenize = tokenize;
        this.includePredefinedRoles = includePredefinedRoles;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider", "getReferencesByElement"));
        }
        String value = this.getStringValue(element);
        PsiReference[] psiReferenceArray = SpringSecurityRolePsiReferenceProvider.getSecurityRolesReferences(element, value, this.tokenize, this.includePredefinedRoles);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getSecurityRolesReferences(@NotNull PsiElement element, @Nullable String value, boolean tokenize, boolean includePredefinedRoles) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider", "getSecurityRolesReferences"));
        }
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!tokenize) {
            return new PsiReference[]{SpringSecurityRolePsiReferenceProvider.getReference(element, value, module, includePredefinedRoles)};
        }
        SmartList references = new SmartList();
        for (String token : StringUtil.tokenize((String)value, (String)",")) {
            if (StringUtil.isEmptyOrSpaces((String)token)) continue;
            references.add(SpringSecurityRolePsiReferenceProvider.getReference(element, token, module, includePredefinedRoles));
        }
        return (PsiReference[])ArrayUtil.toObjectArray((Collection)references, PsiReference.class);
    }

    @Nullable
    protected abstract String getStringValue(PsiElement var1);

    private static PsiReference getReference(PsiElement element, String token, Module module, boolean includePredefinedRoles) {
        return new SpringSecurityRolePsiReference(element, token, module, includePredefinedRoles);
    }

    public static class PsiLiteralExpressionProvider
    extends SpringSecurityRolePsiReferenceProvider {
        public PsiLiteralExpressionProvider(boolean tokenize, boolean roles) {
            super(tokenize, roles);
        }

        @Override
        protected String getStringValue(PsiElement element) {
            if (element instanceof PsiLiteralExpression) {
                Object value = ((PsiLiteralExpression)element).getValue();
                return value instanceof String ? (String)value : null;
            }
            return null;
        }
    }

    public static class XmlAttributeValueProvider
    extends SpringSecurityRolePsiReferenceProvider {
        public XmlAttributeValueProvider(boolean tokenize) {
            super(tokenize, true);
        }

        @Override
        protected String getStringValue(PsiElement element) {
            if (element instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)element).getValue();
            }
            return null;
        }
    }
}

