/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityExpressionRootMethodsUtil {
    @Nullable
    public static PsiMethod findWebSecurityExpressionRootMethod(@Nullable String methodName, @Nullable Module module) {
        return SecurityExpressionRootMethodsUtil.findExpressionMethod(methodName, module, "org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
    }

    private static PsiMethod findExpressionMethod(@Nullable String methodName, @Nullable Module module, String expressionRootClss) {
        if (module != null && methodName != null) {
            for (PsiMethod psiMethod : SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module, expressionRootClss))) {
                if (!methodName.startsWith(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getExpressionRootClass(@Nullable Module module, @NotNull String rootContextClass) {
        if (rootContextClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootContextClass", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootClass"));
        }
        if (module == null) {
            return null;
        }
        PsiClass securityExpressionRoot = SpringCommonUtils.findLibraryClass((Module)module, (String)rootContextClass);
        if (securityExpressionRoot != null) {
            return securityExpressionRoot;
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)SecurityExpressionRootMethodsUtil.getDefaultRootClassName());
    }

    @NotNull
    public static String getDefaultRootClassName() {
        if ("org.springframework.security.access.expression.SecurityExpressionRoot" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getDefaultRootClassName"));
        }
        return "org.springframework.security.access.expression.SecurityExpressionRoot";
    }

    @NotNull
    public static Set<PsiMethod> getExpressionRootMethods(@Nullable Module module, @NotNull String rootContextClass) {
        if (rootContextClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootContextClass", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module, rootContextClass));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiMethod> getExpressionRootMethods(@Nullable PsiClass psiClass) {
        HashSet methods = ContainerUtil.newHashSet();
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (psiMethod.isConstructor() || psiMethod.hasModifierProperty("private") || containingClass == null || containingClass.isInterface() || "java.lang.Object".equals(containingClass.getQualifiedName()) || !PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) continue;
                methods.add(psiMethod);
            }
        }
        HashSet hashSet = methods;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return hashSet;
    }
}

