/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum SpringSecurityVersion {
    V_2_0("2.0", "org.springframework.security.core.userdetails.UserDetailsChecker"),
    V_2_0_6("2.0.6", "org.springframework.security.access.vote.RoleHierarchyVoter"),
    V_2_0_4("2.0.4", "org.springframework.security.config.NamespaceAuthenticationManager"),
    V_3_0("3.0", "org.springframework.security.core.authority.GrantedAuthorityImpl"),
    V_3_0_3("3.0.3", "org.springframework.security.access.intercept.aspectj.MethodInvocationAdapter"),
    V_3_1("3.1", "org.springframework.security.crypto.util.EncodingUtils"),
    V_4_0_4("4.0.4", "org.springframework.security.core.annotation.AuthenticationPrincipal");

    private final String myName;
    private final String myDetectionClassFqn;

    private SpringSecurityVersion(String name, String detectionClassFqn) {
        this.myName = name;
        this.myDetectionClassFqn = detectionClassFqn;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getVersion() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityVersion", "getVersion"));
        }
        return string;
    }

    public String getDetectionClassFqn() {
        return this.myDetectionClassFqn;
    }

    public boolean isAtLeast(SpringSecurityVersion reference) {
        return StringUtil.compareVersionNumbers((String)this.getVersion(), (String)reference.getVersion()) >= 0;
    }
}

