/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.model.xml.GlobalMethodSecurity;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityImplicitBeansProvider
extends CustomLocalComponentsDiscoverer {
    private static final String DEFAULT_ACCESS_DECISION_MANAGER_BEAN_NAME = "org.springframework.security.access.vote.AffirmativeBased#0";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel model) {
        boolean createAccessDecisionManager;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
        }
        Module module = model.getModule();
        if (module == null || module.isDisposed() || !(model instanceof LocalXmlModel)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        PsiClass libraryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.access.AccessDecisionManager");
        if (libraryClass == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        LocalXmlModel localXmlModel = (LocalXmlModel)model;
        DomFileElement root = localXmlModel.getRoot();
        if (root == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        if (!SpringSecurityUtil.isSpringSecurityNamespaceUsed((DomFileElement<Beans>)root)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        boolean bl = createAccessDecisionManager = SpringDomUtils.hasElement((DomFileElement)root, Http.class) || SpringDomUtils.hasElement((DomFileElement)root, GlobalMethodSecurity.class);
        if (!createAccessDecisionManager) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        SpringImplicitBean accessDecisionManager = new SpringImplicitBean("Spring Security", libraryClass, DEFAULT_ACCESS_DECISION_MANAGER_BEAN_NAME);
        Set<SpringImplicitBean> set = Collections.singleton(accessDecisionManager);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityImplicitBeansProvider", "getCustomComponents"));
        }
        return set;
    }
}

