/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.FilterMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.inspections.SpringSecurityBaseInspection;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityFiltersConfiguredInspection
extends SpringSecurityBaseInspection {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        VirtualFile virtualFile = domFileElement.getFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            return;
        }
        if (!SpringSecurityUtil.isSpringSecurityUsed(domFileElement)) {
            return;
        }
        SecurityFilterResult findResult = SpringSecurityFiltersConfiguredInspection.findSpringSecurityFilter(webFacets);
        if (findResult != SecurityFilterResult.FOUND) {
            String filterName = SpringSecurityFiltersConfiguredInspection.getDefaultFilterName(SpringSecurityUtil.getVersion(domFileElement));
            AddSecurityFilterInWebXmlFix fix = findResult == SecurityFilterResult.NOT_FOUND ? new AddSecurityFilterInWebXmlFix(module, filterName) : null;
            holder.createProblem(domFileElement, SpringSecurityBundle.message("filters.configuration.inspection.filter.not.configured", new Object[0]), new LocalQuickFix[]{fix});
        }
    }

    private static String getDefaultFilterName(SpringSecurityVersion version) {
        return version.isAtLeast(SpringSecurityVersion.V_3_0) ? "springSecurityFilterChain" : "filterChainProxy";
    }

    private static SecurityFilterResult findSpringSecurityFilter(Collection<WebFacet> webFacets) {
        boolean foundWebXml = false;
        for (WebFacet webFacet : webFacets) {
            if (webFacet.getWebXmlDescriptor() != null) {
                foundWebXml = true;
            }
            List filters = webFacet.getWebModel().getFilters();
            for (CommonFilter filter : filters) {
                if (!InheritanceUtil.isInheritor((PsiClass)filter.getPsiClass(), (String)"org.springframework.web.filter.DelegatingFilterProxy")) continue;
                return SecurityFilterResult.FOUND;
            }
        }
        return foundWebXml ? SecurityFilterResult.NOT_FOUND : SecurityFilterResult.NOT_FOUND_NO_WEB_XML;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringSecurityFiltersConfiguredInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/inspections/SpringSecurityFiltersConfiguredInspection", "getShortName"));
        }
        return "SpringSecurityFiltersConfiguredInspection";
    }

    private static class AddSecurityFilterInWebXmlFix
    implements LocalQuickFix {
        private final Module myModule;
        private final String myFilterName;

        private AddSecurityFilterInWebXmlFix(@NotNull Module module, String filterName) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/security/inspections/SpringSecurityFiltersConfiguredInspection$AddSecurityFilterInWebXmlFix", "<init>"));
            }
            this.myModule = module;
            this.myFilterName = filterName;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringSecurityBundle.message("filters.configuration.inspection.fix.add.security.filter", "org.springframework.web.filter.DelegatingFilterProxy");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/inspections/SpringSecurityFiltersConfiguredInspection$AddSecurityFilterInWebXmlFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/security/inspections/SpringSecurityFiltersConfiguredInspection$AddSecurityFilterInWebXmlFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/security/inspections/SpringSecurityFiltersConfiguredInspection$AddSecurityFilterInWebXmlFix", "applyFix"));
            }
            this.doFix(project);
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        private void doFix(Project project) {
            Processor processor = webFacet -> {
                ConfigFile webXmlDescriptor = webFacet.getWebXmlDescriptor();
                assert (webXmlDescriptor != null) : webFacet;
                final XmlFile webXmlFile = webXmlDescriptor.getXmlFile();
                new WriteCommandAction.Simple(project, new PsiFile[]{webXmlFile}, (WebFacet)webFacet){
                    final /* synthetic */ WebFacet val$webFacet;
                    {
                        this.val$webFacet = webFacet;
                        super(x0, x1);
                    }

                    protected void run() throws Throwable {
                        WebApp webApp = (WebApp)JamCommonUtil.getRootElement((PsiFile)webXmlFile, WebApp.class, null);
                        if (webApp == null) {
                            return;
                        }
                        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)webXmlFile)) {
                            return;
                        }
                        List names = ContainerUtil.mapNotNull((Collection)this.val$webFacet.getWebModel().getFilters(), (Function)((NullableFunction)filter -> filter.getFilterName().getStringValue()));
                        String filterName = UniqueNameGenerator.generateUniqueName((String)myFilterName, (Collection)names);
                        Filter filter2 = webApp.addFilter();
                        filter2.getFilterName().setStringValue(filterName);
                        filter2.getFilterClass().setStringValue("org.springframework.web.filter.DelegatingFilterProxy");
                        FilterMapping filterMapping = webApp.addFilterMapping();
                        filterMapping.getFilterName().setStringValue(filterName);
                        filterMapping.addUrlPattern().setStringValue("/*");
                        SpringDomUtils.navigate((DomElement)filter2);
                    }
                }.execute();
                return false;
            };
            this.processWebApp((Processor<WebFacet>)processor);
        }

        private void processWebApp(final Processor<WebFacet> processor) {
            List webFacets = ContainerUtil.filter((Collection)WebFacet.getInstances((Module)this.myModule), facet -> facet.getWebXmlDescriptor() != null);
            if (webFacets.isEmpty()) {
                return;
            }
            if (webFacets.size() == 1) {
                processor.process(webFacets.iterator().next());
                return;
            }
            ArrayList list = new ArrayList(webFacets);
            BaseListPopupStep<WebFacet> step = new BaseListPopupStep<WebFacet>(SpringSecurityBundle.message("filters.configuration.inspection.fix.choose.web.set", new Object[0]), list){

                public PopupStep onChosen(WebFacet selectedValue, boolean finalChoice) {
                    processor.process((Object)selectedValue);
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(DataManager.getInstance().getDataContext());
        }
    }

    static enum SecurityFilterResult {
        FOUND,
        NOT_FOUND,
        NOT_FOUND_NO_WEB_XML;

    }
}

