/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml.actions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class JSCreateMethodDialog
extends JSChangeSignatureDialog {
    private CreateAction myCreateAction;
    private final JSClass myTargetClass;
    private JCheckBox myStaticCb;

    public JSCreateMethodDialog(JSClass targetClass, JSFunction method, boolean forceConstructor) {
        super(method, forceConstructor, (PsiElement)method);
        this.myTargetClass = targetClass;
        this.setTitle(JSBundle.message((String)(forceConstructor ? "create.constructor.dialog.title" : "create.method.dialog.title"), (Object[])new Object[0]));
    }

    static JSFunction createFakeMethod(JSClass clazz, String text, boolean inClass) {
        if (inClass) {
            JSExpressionCodeFragment file = JSElementFactory.createExpressionCodeFragment((Project)clazz.getProject(), (CharSequence)((clazz.isInterface() ? "interface" : "class") + " Dummy {" + text + "}"), (PsiElement)clazz, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4, null, (JSElementFactory.TopLevelCompletion)JSElementFactory.TopLevelCompletion.NO, null);
            JSClass aClass = (JSClass)PsiTreeUtil.findChildOfType((PsiElement)file, JSClass.class);
            return aClass.getFunctions()[0];
        }
        JSExpressionCodeFragment file = JSElementFactory.createExpressionCodeFragment((Project)clazz.getProject(), (CharSequence)text, (PsiElement)clazz, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4, null, (JSElementFactory.TopLevelCompletion)JSElementFactory.TopLevelCompletion.NO, null);
        return (JSFunction)PsiTreeUtil.findChildOfType((PsiElement)file, JSFunction.class);
    }

    protected String getDefaultValueColumnTitle() {
        return null;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myCreateAction = new CreateAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.myCreateAction, this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/actions/JSCreateMethodDialog", "createActions"));
        }
        return actionArray;
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        this.close(0);
    }

    protected JSChangeSignatureProcessor createRefactoringProcessor() {
        return null;
    }

    public String getMethodName() {
        return super.getMethodName();
    }

    public String getReturnTypeText() {
        return this.myReturnTypeCodeFragment != null ? this.myReturnTypeCodeFragment.getText() : "";
    }

    protected String getHelpId() {
        return null;
    }

    protected String validateAndCommitData() {
        String error = super.validateAndCommitData();
        if (error != null) {
            return error;
        }
        JSFunction existingMethod = JSInheritanceUtil.findMethodInClass((JSFunction)this.createMethod(), (JSClass)this.myTargetClass, (boolean)true);
        if (existingMethod != null && existingMethod.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC) == (this.myStaticCb != null && this.myStaticCb.isSelected())) {
            boolean contains = existingMethod.getParent() == this.myTargetClass;
            String message = JSBundle.message((String)"class.already.contains.method.warning", (Object[])new Object[]{this.myTargetClass.getQualifiedName(), contains ? 1 : 2, this.getMethodName()});
            if (Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) != 0) {
                return "";
            }
        }
        return null;
    }

    protected String calculateModifiers() {
        String result = super.calculateModifiers();
        if (this.myStaticCb != null && this.myStaticCb.isSelected()) {
            result = result + " static ";
        }
        return result;
    }

    public JSFunction createMethod() {
        String methodText = this.calculateSignature() + (this.myTargetClass.isInterface() ? ";" : "{}");
        return JSCreateMethodDialog.createFakeMethod(this.myTargetClass, methodText, true);
    }

    protected JPanel createVisibilityPanel() {
        JPanel visibilityPanel = super.createVisibilityPanel();
        if (((JSMethodDescriptor)this.myMethod).isConstructor()) {
            return visibilityPanel;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)visibilityPanel, "North");
        this.myStaticCb = new JCheckBox(JSBundle.message((String)"declare.static", (Object[])new Object[0]));
        this.myStaticCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSCreateMethodDialog.this.updateSignature();
            }
        });
        panel.add((Component)this.myStaticCb, "South");
        return panel;
    }

    private class CreateAction
    extends AbstractAction {
        public CreateAction() {
            this.putValue("Name", JSBundle.message((String)"create.button.text", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSCreateMethodDialog.this.doOKAction();
        }
    }
}

