/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramPsiScopeManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.uml.FlashUmlColorManager;
import com.intellij.lang.javascript.uml.FlashUmlDataModel;
import com.intellij.lang.javascript.uml.FlashUmlEdgeCreationPolicy;
import com.intellij.lang.javascript.uml.FlashUmlElementManager;
import com.intellij.lang.javascript.uml.FlashUmlExtras;
import com.intellij.lang.javascript.uml.FlashUmlNodeContentManager;
import com.intellij.lang.javascript.uml.FlashUmlRelationshipManager;
import com.intellij.lang.javascript.uml.FlashUmlVfsResolver;
import com.intellij.lang.javascript.uml.FlashUmlVisibilityManager;
import com.intellij.lang.javascript.uml.actions.JSCreateConstructorAction;
import com.intellij.lang.javascript.uml.actions.JSCreateFieldAction;
import com.intellij.lang.javascript.uml.actions.JSCreateMethodAction;
import com.intellij.lang.javascript.uml.actions.NewActionScriptClassUmlAction;
import com.intellij.lang.javascript.uml.actions.NewFlexComponentUmlAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashUmlProvider
extends DiagramProvider<Object> {
    public static final String ID = "Flash";
    private final FlashUmlVisibilityManager myVisibilityManager = new FlashUmlVisibilityManager();
    private final FlashUmlNodeContentManager myNodeContentManager = new FlashUmlNodeContentManager();
    private final FlashUmlElementManager myElementManager = new FlashUmlElementManager(this);
    private final FlashUmlVfsResolver myVfsResolver = new FlashUmlVfsResolver();
    private final FlashUmlRelationshipManager myRelationshipManager = new FlashUmlRelationshipManager();
    private final FlashUmlColorManager myColorManager = new FlashUmlColorManager();
    private final FlashUmlExtras myExtras = new FlashUmlExtras();
    public static final DiagramCreateNewElementAction[] ELEMENT_ACTIONS = new DiagramCreateNewElementAction[]{new NewActionScriptClassUmlAction(), new NewFlexComponentUmlAction()};
    public static final DiagramCreateNewNodeElementAction[] NODE_ACTIONS = new DiagramCreateNewNodeElementAction[]{new JSCreateFieldAction(), new JSCreateMethodAction(), new JSCreateConstructorAction()};

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public FlashUmlVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public FlashUmlNodeContentManager getNodeContentManager() {
        return this.myNodeContentManager;
    }

    public FlashUmlElementManager getElementManager() {
        return this.myElementManager;
    }

    public FlashUmlVfsResolver getVfsResolver() {
        return this.myVfsResolver;
    }

    public FlashUmlRelationshipManager getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public FlashUmlDataModel createDataModel(@NotNull Project project, @Nullable Object element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/uml/FlashUmlProvider", "createDataModel"));
        }
        if (element instanceof JSFile) {
            element = JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)element));
        } else if (element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) {
            element = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
        } else if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            element = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)directory.getVirtualFile(), (Project)directory.getProject());
        }
        return new FlashUmlDataModel(project, element, file, this);
    }

    public DiagramScopeManager<Object> createScopeManager(Project project) {
        return new DiagramPsiScopeManager(project);
    }

    public DiagramColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public FlashUmlExtras getExtras() {
        FlashUmlExtras flashUmlExtras = this.myExtras;
        if (flashUmlExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlProvider", "getExtras"));
        }
        return flashUmlExtras;
    }

    public DiagramCreateNewElementAction<Object, ?>[] getCreateNewActions() {
        return ELEMENT_ACTIONS;
    }

    public DiagramCreateNewNodeElementAction<Object, ?>[] getCreateNewNodeElementActions() {
        return NODE_ACTIONS;
    }

    public String getPresentableName() {
        return JSBundle.message((String)"js.uml.presentable.name", (Object[])new Object[0]);
    }

    public DiagramEdgeCreationPolicy<Object> getEdgeCreationPolicy() {
        return new FlashUmlEdgeCreationPolicy();
    }
}

