/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.actions.newfile.NewFlexComponentAction;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.uml.FlashUmlClassNode;
import com.intellij.lang.javascript.uml.FlashUmlDependenciesSettingsOption;
import com.intellij.lang.javascript.uml.FlashUmlDependencyProvider;
import com.intellij.lang.javascript.uml.FlashUmlEdge;
import com.intellij.lang.javascript.uml.FlashUmlElementManager;
import com.intellij.lang.javascript.uml.FlashUmlPackageNode;
import com.intellij.lang.javascript.uml.FlashUmlRelationship;
import com.intellij.lang.javascript.uml.FlashUmlVfsResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashUmlDataModel
extends DiagramDataModel<Object> {
    private final Map<String, SmartPsiElementPointer<JSClass>> classesAddedByUser = new HashMap<String, SmartPsiElementPointer<JSClass>>();
    private final Map<String, SmartPsiElementPointer<JSClass>> classesRemovedByUser = new HashMap<String, SmartPsiElementPointer<JSClass>>();
    private final String initialPackage;
    private SmartPsiElementPointer<? extends PsiElement> myInitialElement;
    private final Set<String> packages = new HashSet<String>();
    private final Set<String> packagesRemovedByUser = new HashSet<String>();
    private final VirtualFile myEditorFile;
    private final SmartPointerManager spManager;
    private final Collection<DiagramNode<Object>> myNodes = new HashSet<DiagramNode<Object>>();
    private final Collection<DiagramEdge<Object>> myEdges = new HashSet<DiagramEdge<Object>>();
    private final Collection<DiagramEdge<Object>> myDependencyEdges = new HashSet<DiagramEdge<Object>>();
    private final Collection<DiagramNode<Object>> myNodesOld = new HashSet<DiagramNode<Object>>();
    private final Collection<DiagramEdge<Object>> myEdgesOld = new HashSet<DiagramEdge<Object>>();
    private final Collection<DiagramEdge<Object>> myDependencyEdgesOld = new HashSet<DiagramEdge<Object>>();

    public FlashUmlDataModel(Project project, Object element, VirtualFile file, DiagramProvider<Object> provider) {
        super(project, provider);
        this.myEditorFile = file;
        this.spManager = SmartPointerManager.getInstance((Project)project);
        if (element instanceof JSClass) {
            this.initialPackage = null;
            this.myInitialElement = this.spManager.createSmartPsiElementPointer((PsiElement)((JSClass)element));
            JSClass psiClass = (JSClass)element;
            this.classesAddedByUser.put(psiClass.getQualifiedName(), this.myInitialElement);
            Collection classes = JSInheritanceUtil.findAllParentsForClass((JSClass)psiClass, (boolean)true);
            for (JSClass aClass : classes) {
                this.classesAddedByUser.put(aClass.getQualifiedName(), (SmartPsiElementPointer<JSClass>)this.spManager.createSmartPsiElementPointer((PsiElement)aClass));
            }
        } else if (element instanceof String) {
            this.initialPackage = (String)element;
            GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
            for (String aPackage : FlashUmlDataModel.getSubPackages(this.initialPackage, searchScope)) {
                this.packages.add(aPackage);
            }
            for (JSClass jsClass : FlashUmlDataModel.getClasses(this.initialPackage, searchScope)) {
                this.classesAddedByUser.put(jsClass.getQualifiedName(), (SmartPsiElementPointer<JSClass>)this.spManager.createSmartPsiElementPointer((PsiElement)jsClass));
            }
        } else {
            this.initialPackage = null;
        }
    }

    private static Collection<String> getSubPackages(final String packageName, GlobalSearchScope searchScope) {
        final HashSet<String> result = new HashSet<String>();
        JSPackageIndex.processElementsInScope((String)packageName, null, (JSPackageIndex.PackageElementsProcessor)new JSPackageIndex.PackageElementsProcessor(){

            public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (kind == JSPackageIndexInfo.Kind.PACKAGE) {
                    result.add(StringUtil.getQualifiedName((String)packageName, (String)name));
                }
                return true;
            }
        }, (GlobalSearchScope)searchScope, (Project)searchScope.getProject());
        return result;
    }

    private static Collection<JSClass> getClasses(final String packageName, final GlobalSearchScope searchScope) {
        final HashSet<JSClass> result = new HashSet<JSClass>();
        JSPackageIndex.processElementsInScope((String)packageName, null, (JSPackageIndex.PackageElementsProcessor)new JSPackageIndex.PackageElementsProcessor(){

            public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                PsiElement element;
                String qualifiedName = StringUtil.getQualifiedName((String)packageName, (String)name);
                if ((kind == JSPackageIndexInfo.Kind.CLASS || kind == JSPackageIndexInfo.Kind.INTERFACE) && (element = ActionScriptClassResolver.findClassByQNameStatic(qualifiedName, searchScope)) instanceof JSClass) {
                    result.add((JSClass)element);
                }
                return true;
            }
        }, (GlobalSearchScope)searchScope, (Project)searchScope.getProject());
        return result;
    }

    @NotNull
    public Collection<DiagramNode<Object>> getNodes() {
        ArrayList<DiagramNode<Object>> arrayList = new ArrayList<DiagramNode<Object>>(this.myNodes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getNodes"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<Object>> getEdges() {
        if (this.myDependencyEdges.isEmpty()) {
            Collection<DiagramEdge<Object>> collection = this.myEdges;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getEdges"));
            }
            return collection;
        }
        HashSet<DiagramEdge<Object>> allEdges = new HashSet<DiagramEdge<Object>>(this.myEdges);
        allEdges.addAll(this.myDependencyEdges);
        HashSet<DiagramEdge<Object>> hashSet = allEdges;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getEdges"));
        }
        return hashSet;
    }

    @NotNull
    @NonNls
    public String getNodeName(DiagramNode<Object> node) {
        Object element = FlashUmlDataModel.getIdentifyingElement(node);
        if (element instanceof JSClass) {
            String string = "Class " + ((JSClass)element).getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getNodeName"));
            }
            return string;
        }
        if (element instanceof String) {
            String string = "Package " + element;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getNodeName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getNodeName"));
        }
        return "";
    }

    public void removeNode(DiagramNode<Object> node) {
        this.removeElement(FlashUmlDataModel.getIdentifyingElement(node));
    }

    public void removeEdge(DiagramEdge<Object> edge) {
        Object source = edge.getSource().getIdentifyingElement();
        Object target = edge.getTarget().getIdentifyingElement();
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (!(source instanceof JSClass) || !(target instanceof JSClass) || relationship == DiagramRelationshipInfo.NO_RELATIONSHIP) {
            return;
        }
        JSClass fromClass = (JSClass)source;
        JSClass toClass = (JSClass)target;
        if (JSProjectUtil.isInLibrary((PsiElement)fromClass)) {
            return;
        }
        if (fromClass instanceof XmlBackedJSClassImpl && !toClass.isInterface()) {
            Messages.showErrorDialog((Project)fromClass.getProject(), (String)FlexBundle.message("base.component.needed.message", new Object[0]), (String)FlexBundle.message("remove.edge.title", new Object[0]));
            return;
        }
        if (Messages.showYesNoDialog((Project)fromClass.getProject(), (String)FlexBundle.message("remove.inheritance.link.prompt", fromClass.getQualifiedName(), toClass.getQualifiedName()), (String)FlexBundle.message("remove.edge.title", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        Runnable runnable = () -> {
            JSReferenceList refList = !fromClass.isInterface() && toClass.isInterface() ? fromClass.getImplementsList() : fromClass.getExtendsList();
            ArrayList formatters = new ArrayList();
            JSRefactoringUtil.removeFromReferenceList((JSReferenceList)refList, (JSClass)toClass, formatters);
            if (!(fromClass instanceof XmlBackedJSClassImpl) && FlashUmlDataModel.needsImport(fromClass, toClass)) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)fromClass.getContainingFile()));
            }
            FormatFixer.fixAll(formatters);
        };
        DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)FlexBundle.message("remove.relationship.command.name", new Object[0]), null, (PsiElement[])new PsiElement[]{fromClass.getContainingFile()});
    }

    private static boolean needsImport(JSClass context, JSClass referenced) {
        String packageName = StringUtil.getPackageName((String)referenced.getQualifiedName());
        return !packageName.isEmpty() && !packageName.equals(StringUtil.getPackageName((String)context.getQualifiedName()));
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    private void clearAll() {
        FlashUmlDataModel.clearAndBackup(this.myNodes, this.myNodesOld);
        FlashUmlDataModel.clearAndBackup(this.myEdges, this.myEdgesOld);
        FlashUmlDataModel.clearAndBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    public void removeAllElements() {
        this.classesRemovedByUser.clear();
        this.classesRemovedByUser.putAll(this.classesAddedByUser);
        this.classesAddedByUser.clear();
        this.packagesRemovedByUser.clear();
        this.packagesRemovedByUser.addAll(this.packages);
        this.packages.clear();
        this.clearAll();
    }

    private boolean isAllowedToShow(JSClass psiClass) {
        if (psiClass == null || !psiClass.isValid()) {
            return false;
        }
        DiagramScopeManager scopeManager = this.getScopeManager();
        if (scopeManager != null && !scopeManager.contains((Object)psiClass)) {
            return false;
        }
        PsiElement initialElement = this.getInitialElement();
        if (this.isInsidePackages(psiClass)) {
            return false;
        }
        if (initialElement instanceof JSClass && FlashUmlDataModel.equals(psiClass, (JSClass)initialElement)) {
            return true;
        }
        return true;
    }

    private static boolean equals(JSClass one, JSClass another) {
        return one != null && one.isValid() && another != null && another.isValid() && one.getQualifiedName() != null && one.getQualifiedName().equals(another.getQualifiedName());
    }

    public synchronized void updateDataModel() {
        Set<JSClass> classes = this.getAllClasses();
        this.syncPackages();
        HashSet<JSClass> interfaces = new HashSet<JSClass>();
        for (String psiPackage : this.packages) {
            if (!FlashUmlElementManager.packageExists(this.getProject(), psiPackage, GlobalSearchScope.allScope((Project)this.getProject()))) continue;
            this.myNodes.add((DiagramNode<Object>)new FlashUmlPackageNode(psiPackage, this.getProvider()));
        }
        for (JSClass psiClass : classes) {
            if (this.isAllowedToShow(psiClass)) {
                this.myNodes.add((DiagramNode<Object>)new FlashUmlClassNode(psiClass, this.getProvider()));
            }
            if (!psiClass.isInterface()) continue;
            interfaces.add(psiClass);
        }
        for (JSClass psiClass : classes) {
            JSClass[] source = this.findNode(psiClass);
            Object target = null;
            ArrayList<JSClass> processed = new ArrayList<JSClass>();
            JSClass superClass = FlashUmlDataModel.getSuperClass(psiClass, processed);
            while (target == null && superClass != null) {
                target = this.findNode(superClass);
                superClass = FlashUmlDataModel.getSuperClass(superClass, processed);
            }
            if (!(source == null || target == null || source == target || ((JSClass)FlashUmlDataModel.getIdentifyingElement((DiagramNode)source)).isInterface() && JSResolveUtil.isObjectClass((JSClass)((JSClass)FlashUmlDataModel.getIdentifyingElement(target))))) {
                this.addEdge((DiagramNode<Object>)source, (DiagramNode<Object>)target, psiClass.isInterface() ? FlashUmlRelationship.INTERFACE_GENERALIZATION : FlashUmlRelationship.GENERALIZATION);
            }
            for (JSClass inter : psiClass.getImplementedInterfaces()) {
                if (!interfaces.contains(inter)) continue;
                DiagramNode<Object> source2 = this.findNode(psiClass);
                DiagramNode<Object> target2 = this.findNode(inter);
                if (source2 == null || target2 == null || source2 == target2) continue;
                this.addEdge(source2, target2, FlashUmlRelationship.REALIZATION);
            }
            if (psiClass.isInterface()) {
                HashSet<JSClass> found = new HashSet<JSClass>();
                FlashUmlDataModel.findNearestInterfaces(psiClass, found);
                for (JSClass inter : found) {
                    if (!interfaces.contains(inter)) continue;
                    DiagramNode<Object> source3 = this.findNode(psiClass);
                    DiagramNode<Object> target3 = this.findNode(inter);
                    if (source3 == null || target3 == null || source3 == target3) continue;
                    this.addEdge(source3, target3, FlashUmlRelationship.INTERFACE_GENERALIZATION);
                }
                continue;
            }
            HashSet inters = new HashSet();
            ContainerUtil.addAll(inters, (Object[])psiClass.getImplementedInterfaces());
            ArrayList<JSClass> processed2 = new ArrayList<JSClass>();
            JSClass cur = FlashUmlDataModel.getSuperClass(psiClass, processed2);
            while (cur != null && this.findNode(cur) == null) {
                ContainerUtil.addAll(inters, (Object[])cur.getImplementedInterfaces());
                cur = FlashUmlDataModel.getSuperClass(cur, processed2);
            }
            ArrayList faces = new ArrayList(inters);
            while (!faces.isEmpty()) {
                JSClass inter = (JSClass)faces.get(0);
                if (this.findNode(inter) != null) {
                    DiagramNode<Object> source4 = this.findNode(psiClass);
                    DiagramNode<Object> target4 = this.findNode(inter);
                    if (source4 != null && target4 != null && source4 != target4) {
                        this.addEdge(source4, target4, FlashUmlRelationship.REALIZATION);
                    }
                    faces.remove(inter);
                    continue;
                }
                faces.remove(inter);
                ContainerUtil.addAll(faces, (Object[])inter.getImplementedInterfaces());
            }
        }
        if (this.isShowDependencies()) {
            EnumSet<FlashUmlDependenciesSettingsOption> options = FlashUmlDependenciesSettingsOption.getEnabled();
            for (JSClass psiClass : classes) {
                this.showDependenciesFor(psiClass, options);
            }
        }
        FlashUmlDataModel.mergeWithBackup(this.myNodes, this.myNodesOld);
        FlashUmlDataModel.mergeWithBackup(this.myEdges, this.myEdgesOld);
        FlashUmlDataModel.mergeWithBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    private void showDependenciesFor(JSClass clazz, EnumSet<FlashUmlDependenciesSettingsOption> options) {
        DiagramNode<Object> mainNode = this.findNode(clazz);
        if (mainNode == null) {
            return;
        }
        FlashUmlDependencyProvider provider = new FlashUmlDependencyProvider(clazz);
        Collection<Pair<JSClass, FlashUmlRelationship>> list = provider.computeUsedClasses();
        for (Pair<JSClass, FlashUmlRelationship> pair : list) {
            DiagramNode<Object> node;
            if (!FlashUmlDataModel.shouldShow(options, clazz, (JSClass)pair.first, (FlashUmlRelationship)pair.second) || (node = this.findNode(pair.first)) == null) continue;
            this.addDependencyEdge(mainNode, node, (DiagramRelationshipInfo)pair.second);
        }
    }

    private static boolean shouldShow(EnumSet<FlashUmlDependenciesSettingsOption> options, JSClass from, JSClass to, FlashUmlRelationship relShip) {
        if (JSResolveUtil.isObjectClass((JSClass)from) && JSResolveUtil.isObjectClass((JSClass)to)) {
            return false;
        }
        if (!options.contains((Object)FlashUmlDependenciesSettingsOption.SELF) && JSPsiImplUtils.isTheSameClass((PsiElement)from, (JSQualifiedNamedElement)to)) {
            return false;
        }
        if (!options.contains((Object)FlashUmlDependenciesSettingsOption.ONE_TO_ONE) && relShip.getType() == "ONE_TO_ONE") {
            return false;
        }
        if (!options.contains((Object)FlashUmlDependenciesSettingsOption.ONE_TO_MANY) && relShip.getType() == "ONE_TO_MANY") {
            return false;
        }
        if (!options.contains((Object)FlashUmlDependenciesSettingsOption.USAGES) && relShip.getType() == "DEPENDENCY") {
            return false;
        }
        return options.contains((Object)FlashUmlDependenciesSettingsOption.CREATE) || relShip.getType() != "CREATE";
    }

    @Nullable
    private static JSClass getSuperClass(JSClass psiClass, Collection<JSClass> processed) {
        JSClass[] superClasses = psiClass.getSuperClasses();
        if (superClasses.length > 0 && !superClasses[0].isEquivalentTo((PsiElement)psiClass) && !JSPsiImplUtils.containsEquivalent(processed, (PsiElement)superClasses[0])) {
            processed.add(superClasses[0]);
            return superClasses[0];
        }
        return null;
    }

    private static <T> void clearAndBackup(Collection<T> target, Collection<T> backup) {
        backup.clear();
        backup.addAll(target);
        target.clear();
    }

    private static <T> void mergeWithBackup(Collection<T> target, Collection<T> backup) {
        for (T t : backup) {
            if (!target.contains(t)) continue;
            target.remove(t);
            target.add(t);
        }
    }

    private void syncPackages() {
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (this.initialPackage == null || FlashUmlElementManager.packageExists(this.getProject(), this.initialPackage, searchScope)) {
            return;
        }
        HashSet<String> psiPackages = new HashSet<String>();
        for (String sub : FlashUmlDataModel.getSubPackages(this.initialPackage, searchScope)) {
            psiPackages.add(sub);
        }
        for (String fqn : this.packages) {
            psiPackages.remove(fqn);
        }
        for (String fqn : this.packagesRemovedByUser) {
            psiPackages.remove(fqn);
        }
        if (psiPackages.size() > 0) {
            this.packages.addAll(psiPackages);
        }
    }

    private static void findNearestInterfaces(JSClass psiClass, Set<JSClass> result) {
        for (JSClass anInterface : psiClass.getSuperClasses()) {
            if (result.contains(anInterface)) continue;
            result.add(anInterface);
            FlashUmlDataModel.findNearestInterfaces(anInterface, result);
        }
    }

    private static boolean isGeneralizationEdgeAllowed(JSClass psiClass) {
        return !psiClass.isInterface();
    }

    private boolean isInsidePackages(JSClass psiClass) {
        return this.packages.contains(StringUtil.getPackageName((String)psiClass.getQualifiedName()));
    }

    public FlashUmlEdge addEdge(DiagramNode<Object> from, DiagramNode<Object> to, DiagramRelationshipInfo relationship) {
        return FlashUmlDataModel.addEdge(from, to, relationship, this.myEdges);
    }

    public FlashUmlEdge addDependencyEdge(DiagramNode<Object> from, DiagramNode<Object> to, DiagramRelationshipInfo relationship) {
        return FlashUmlDataModel.addEdge(from, to, relationship, this.myDependencyEdges);
    }

    private static FlashUmlEdge addEdge(DiagramNode<Object> from, DiagramNode<Object> to, DiagramRelationshipInfo relationship, Collection<DiagramEdge<Object>> storage) {
        for (DiagramEdge<Object> edge : storage) {
            if (edge.getSource() != from || edge.getTarget() != to || !relationship.equals(edge.getRelationship())) continue;
            return null;
        }
        FlashUmlEdge result = new FlashUmlEdge(from, to, relationship);
        storage.add((DiagramEdge<Object>)result);
        return result;
    }

    private Set<JSClass> getAllClasses() {
        HashSet<JSClass> classes = new HashSet<JSClass>();
        for (SmartPsiElementPointer<JSClass> smartPsiElementPointer : this.classesAddedByUser.values()) {
            classes.add((JSClass)smartPsiElementPointer.getElement());
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (this.initialPackage != null && FlashUmlElementManager.packageExists(this.getProject(), this.initialPackage, searchScope)) {
            classes.addAll(FlashUmlDataModel.getClasses(this.initialPackage, searchScope));
        }
        for (String psiPackage : this.packages) {
            if (!FlashUmlElementManager.packageExists(this.getProject(), psiPackage, searchScope)) continue;
            classes.addAll(FlashUmlDataModel.getClasses(psiPackage, searchScope));
        }
        classes.remove(null);
        HashSet<JSClass> hashSet = new HashSet<JSClass>();
        for (JSClass jSClass : classes) {
            if (jSClass.isValid()) continue;
            hashSet.add(jSClass);
        }
        for (SmartPsiElementPointer smartPsiElementPointer : this.classesRemovedByUser.values()) {
            classes.remove(smartPsiElementPointer.getElement());
        }
        classes.removeAll(hashSet);
        return classes;
    }

    @Nullable
    public DiagramNode<Object> findNode(Object object) {
        String objectFqn = FlashUmlDataModel.getFqn(object);
        for (DiagramNode<Object> node : this.getNodes()) {
            String fqn = FlashUmlDataModel.getFqn(FlashUmlDataModel.getIdentifyingElement(node));
            if (fqn == null || !fqn.equals(objectFqn) || object instanceof JSClass && !(node instanceof FlashUmlClassNode) || object instanceof String && !(node instanceof FlashUmlPackageNode)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private static String getFqn(Object element) {
        if (element instanceof JSQualifiedNamedElement) {
            String qName = ((JSQualifiedNamedElement)element).getQualifiedName();
            return qName != null ? FlashUmlVfsResolver.fixVectorTypeName(qName) : null;
        }
        if (element instanceof String) {
            return (String)element;
        }
        return null;
    }

    public boolean contains(PsiElement psiElement) {
        return this.findNode(psiElement) != null;
    }

    public void dispose() {
    }

    public void removeElement(Object element) {
        DiagramNode<Object> node = this.findNode(element);
        if (node == null) {
            this.classesAddedByUser.remove(FlashUmlDataModel.getFqn(element));
            return;
        }
        ArrayList<DiagramEdge<Object>> edgesToRemove = new ArrayList<DiagramEdge<Object>>();
        for (DiagramEdge<Object> diagramEdge : this.myEdges) {
            if (!node.equals((Object)diagramEdge.getTarget()) && !node.equals((Object)diagramEdge.getSource())) continue;
            edgesToRemove.add(diagramEdge);
        }
        this.myEdges.removeAll(edgesToRemove);
        ArrayList<DiagramEdge<Object>> dependencyEdgesToRemove = new ArrayList<DiagramEdge<Object>>();
        for (DiagramEdge<Object> diagramEdge : this.myDependencyEdges) {
            if (!node.equals((Object)diagramEdge.getTarget()) && !node.equals((Object)diagramEdge.getSource())) continue;
            dependencyEdgesToRemove.add(diagramEdge);
        }
        this.myDependencyEdges.removeAll(dependencyEdgesToRemove);
        this.myNodes.remove(node);
        if (element instanceof JSClass) {
            JSClass jSClass = (JSClass)element;
            this.classesRemovedByUser.put(jSClass.getQualifiedName(), (SmartPsiElementPointer<JSClass>)this.spManager.createSmartPsiElementPointer((PsiElement)jSClass));
            this.classesAddedByUser.remove(jSClass.getQualifiedName());
        }
        if (element instanceof String) {
            String string = (String)element;
            this.packages.remove(string);
            this.packagesRemovedByUser.add(string);
            HashSet<String> hashSet = new HashSet<String>();
            for (String key : this.classesAddedByUser.keySet()) {
                SmartPsiElementPointer<JSClass> pointer = this.classesAddedByUser.get(key);
                JSClass psiClass = (JSClass)pointer.getElement();
                if (!string.equals(StringUtil.getPackageName((String)psiClass.getQualifiedName()))) continue;
                hashSet.add(key);
            }
            for (String key : hashSet) {
                this.classesAddedByUser.remove(key);
            }
        }
    }

    @Nullable
    public DiagramNode<Object> addElement(Object element) {
        if (this.findNode(element) != null) {
            return null;
        }
        if (element instanceof JSClass) {
            if (!this.isAllowedToShow((JSClass)element)) {
                return null;
            }
            JSClass psiClass = (JSClass)element;
            if (psiClass.getQualifiedName() == null) {
                return null;
            }
            SmartPsiElementPointer pointer = this.spManager.createSmartPsiElementPointer((PsiElement)psiClass);
            String fqn = psiClass.getQualifiedName();
            this.classesAddedByUser.put(fqn, (SmartPsiElementPointer<JSClass>)pointer);
            this.classesRemovedByUser.remove(fqn);
            this.setupScopeManager(psiClass, true);
            return new FlashUmlClassNode((JSClass)element, this.getProvider());
        }
        if (element instanceof String) {
            String aPackage = (String)element;
            this.packages.add(aPackage);
            this.packagesRemovedByUser.remove(aPackage);
            return new FlashUmlPackageNode(aPackage, this.getProvider());
        }
        return null;
    }

    public void expandNode(DiagramNode<Object> node) {
        Object element = node.getIdentifyingElement();
        if (element instanceof String) {
            this.expandPackage((String)element);
        }
    }

    public void expandPackage(String psiPackage) {
        this.packages.remove(psiPackage);
        this.packagesRemovedByUser.add(psiPackage);
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.getProject());
        for (JSClass psiClass : FlashUmlDataModel.getClasses(psiPackage, searchScope)) {
            this.addElement(psiClass);
        }
        for (String aPackage : FlashUmlDataModel.getSubPackages(psiPackage, searchScope)) {
            this.addElement(aPackage);
        }
    }

    public void collapseNode(DiagramNode<Object> node) {
        Object element = node.getIdentifyingElement();
        String fqn = FlashUmlDataModel.getFqn(element);
        if (fqn == null) {
            return;
        }
        String parentPackage = StringUtil.getPackageName((String)fqn);
        if (parentPackage.isEmpty()) {
            return;
        }
        String fqnStart = parentPackage + ".";
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String p : this.packages) {
            if (!p.startsWith(fqnStart)) continue;
            toRemove.add(p);
        }
        this.packages.removeAll(toRemove);
        toRemove.clear();
        for (String s : this.classesAddedByUser.keySet()) {
            if (!s.startsWith(fqnStart)) continue;
            toRemove.add(s);
        }
        for (String s : toRemove) {
            this.classesAddedByUser.remove(s);
        }
        this.packages.add(parentPackage);
        this.packagesRemovedByUser.remove(parentPackage);
    }

    List<String> getAllClassesFQN() {
        ArrayList<String> fqns = new ArrayList<String>();
        for (DiagramNode<Object> node : this.getNodes()) {
            Object identifyingElement = FlashUmlDataModel.getIdentifyingElement(node);
            if (!(identifyingElement instanceof JSClass)) continue;
            fqns.add(((JSClass)identifyingElement).getQualifiedName());
        }
        return fqns;
    }

    List<String> getAllPackagesFQN() {
        ArrayList<String> fqns = new ArrayList<String>();
        for (DiagramNode<Object> node : this.getNodes()) {
            Object identifyingElement = FlashUmlDataModel.getIdentifyingElement(node);
            if (!(identifyingElement instanceof JSPackage)) continue;
            fqns.add(((JSPackage)identifyingElement).getQualifiedName());
        }
        return fqns;
    }

    @Nullable
    public PsiElement getInitialElement() {
        if (this.myInitialElement == null) {
            return null;
        }
        PsiElement element = this.myInitialElement.getElement();
        return element == null || !element.isValid() ? null : element;
    }

    public String getInitialPackage() {
        return this.initialPackage;
    }

    public boolean hasNotValid() {
        for (DiagramNode<Object> node : this.getNodes()) {
            if (this.isValid(FlashUmlDataModel.getIdentifyingElement(node))) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(Object element) {
        if (element instanceof PsiElement) {
            return ((PsiElement)element).isValid();
        }
        return false;
    }

    public static String getMessage(JSClass source, JSClass target, DiagramRelationshipInfo relationship) {
        if (relationship == FlashUmlRelationship.ANNOTATION) {
            return "Remove annotation from class";
        }
        return "This will remove relationship between classes";
    }

    public VirtualFile getFile() {
        return this.myEditorFile;
    }

    public boolean hasElement(Object element) {
        return this.findNode(element) != null;
    }

    public boolean isPsiListener() {
        return true;
    }

    @Nullable
    public static Object getIdentifyingElement(DiagramNode node) {
        DiagramNode delegate;
        if (node instanceof FlashUmlClassNode || node instanceof FlashUmlPackageNode) {
            return node.getIdentifyingElement();
        }
        if (node instanceof DiagramNoteNode && (delegate = ((DiagramNoteNode)node).getIdentifyingElement()) != node) {
            return FlashUmlDataModel.getIdentifyingElement(delegate);
        }
        return null;
    }

    @Nullable
    public DiagramEdge<Object> createEdge(@NotNull DiagramNode<Object> from, @NotNull DiagramNode<Object> to) {
        JSClass currentParent;
        JSClass toClass;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "createEdge"));
        }
        JSClass fromClass = (JSClass)from.getIdentifyingElement();
        if (fromClass.isEquivalentTo((PsiElement)(toClass = (JSClass)to.getIdentifyingElement()))) {
            return null;
        }
        if (toClass.isInterface()) {
            if (JSPsiImplUtils.containsEquivalent((PsiElement[])(fromClass.isInterface() ? fromClass.getSuperClasses() : fromClass.getImplementedInterfaces()), (PsiElement)toClass)) {
                return null;
            }
            Callable<DiagramEdge> callable = () -> {
                if (from == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$1"));
                }
                if (to == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$1"));
                }
                String targetQName = toClass.getQualifiedName();
                JSRefactoringUtil.addToSupersList((JSClass)fromClass, (String)targetQName, (boolean)true);
                if (targetQName.contains(".") && !(fromClass instanceof XmlBackedJSClassImpl)) {
                    ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
                    formatters.add(ImportUtils.insertImportStatements((PsiElement)fromClass, Collections.singletonList(targetQName)));
                    formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)fromClass.getContainingFile()));
                    FormatFixer.fixAll(formatters);
                }
                return this.addEdgeAndRefresh(from, to, fromClass.isInterface() ? FlashUmlRelationship.GENERALIZATION : FlashUmlRelationship.INTERFACE_GENERALIZATION);
            };
            String commandName = FlexBundle.message(fromClass.isInterface() ? "create.extends.relationship.command.name" : "create.implements.relationship.command.name", fromClass.getQualifiedName(), toClass.getQualifiedName());
            return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{fromClass.getContainingFile()});
        }
        if (fromClass.isInterface()) {
            return null;
        }
        if (fromClass instanceof XmlBackedJSClassImpl) {
            JSClass currentParent2;
            JSClass[] superClasses = fromClass.getSuperClasses();
            if (JSPsiImplUtils.containsEquivalent((PsiElement[])superClasses, (PsiElement)toClass)) {
                return null;
            }
            if (superClasses.length > 0 && Messages.showYesNoDialog((String)FlexBundle.message("replace.base.component.prompt", (currentParent2 = superClasses[0]).getQualifiedName(), toClass.getQualifiedName()), (String)FlexBundle.message("create.edge.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 1) {
                return null;
            }
            Callable<DiagramEdge> callable = () -> {
                if (from == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$2"));
                }
                if (to == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$2"));
                }
                NewFlexComponentAction.setParentComponent((MxmlJSClass)fromClass, toClass.getQualifiedName());
                return this.addEdgeAndRefresh(from, to, DiagramRelationships.GENERALIZATION);
            };
            String commandName = FlexBundle.message("create.extends.relationship.command.name", fromClass.getQualifiedName(), toClass.getQualifiedName());
            return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{fromClass.getContainingFile()});
        }
        JSClass[] superClasses = fromClass.getSuperClasses();
        if (JSPsiImplUtils.containsEquivalent((PsiElement[])superClasses, (PsiElement)toClass)) {
            return null;
        }
        if (superClasses.length > 0 && !JSResolveUtil.isObjectClass((JSClass)superClasses[0]) && Messages.showYesNoDialog((String)FlexBundle.message("replace.base.class.prompt", (currentParent = superClasses[0]).getQualifiedName(), toClass.getQualifiedName()), (String)FlexBundle.message("create.edge.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 1) {
            return null;
        }
        Callable<DiagramEdge> callable = () -> {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$3"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/lang/javascript/uml/FlashUmlDataModel", "lambda$createEdge$3"));
            }
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            boolean optimize = false;
            if (superClasses.length > 0 && !JSResolveUtil.isObjectClass((JSClass)superClasses[0])) {
                JSRefactoringUtil.removeFromReferenceList((JSReferenceList)fromClass.getExtendsList(), (JSClass)superClasses[0], formatters);
                optimize = FlashUmlDataModel.needsImport(fromClass, superClasses[0]);
            }
            JSRefactoringUtil.addToSupersList((JSClass)fromClass, (String)toClass.getQualifiedName(), (boolean)false);
            if (FlashUmlDataModel.needsImport(fromClass, toClass)) {
                formatters.add(ImportUtils.insertImportStatements((PsiElement)fromClass, Collections.singletonList(toClass.getQualifiedName())));
                optimize = true;
            }
            if (optimize) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)fromClass.getContainingFile()));
            }
            FormatFixer.fixAll(formatters);
            return this.addEdgeAndRefresh(from, to, DiagramRelationships.GENERALIZATION);
        };
        String commandName = FlexBundle.message("create.extends.relationship.command.name", fromClass.getQualifiedName(), toClass.getQualifiedName());
        return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{fromClass.getContainingFile()});
    }

    private DiagramEdge<Object> addEdgeAndRefresh(DiagramNode<Object> from, DiagramNode<Object> to, DiagramRelationshipInfo type) {
        FlashUmlEdge result = this.addEdge(from, to, type);
        DiagramBuilder builder = this.getBuilder();
        if (builder != null) {
            builder.update(true, false);
        }
        return result;
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }
}

