/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.generation.ActionScriptGenerateEventHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateEventHandlerIntention
extends BaseIntentionAction {
    public CreateEventHandlerIntention() {
        this.setText(FlexBundle.message("intention.create.event.handler", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/CreateEventHandlerIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        String eventType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/CreateEventHandlerIntention", "isAvailable"));
        }
        XmlAttribute xmlAttribute = ActionScriptGenerateEventHandler.getXmlAttribute(file, editor);
        String string = eventType = xmlAttribute == null ? null : ActionScriptGenerateEventHandler.getEventType(xmlAttribute);
        if (eventType != null) {
            return true;
        }
        JSCallExpression callExpression = ActionScriptGenerateEventHandler.getEventListenerCallExpression(file, editor);
        if (callExpression != null) {
            return true;
        }
        Trinity<JSExpressionStatement, String, String> eventConstantInfo = ActionScriptGenerateEventHandler.getEventConstantInfo(file, editor);
        return eventConstantInfo != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/CreateEventHandlerIntention", "invoke"));
        }
        new ActionScriptGenerateEventHandler().invoke(project, editor, file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

