/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSImplicitlyInternalDeclarationInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("js.implicitly.internal.declaration.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)aClass, holder);
            }

            public void visitJSLocalVariable(JSLocalVariable var) {
            }

            public void visitJSVariable(JSVariable node) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)node, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSImplicitlyInternalDeclarationInspection.process((JSNamedElement)node, holder);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void process(JSNamedElement node, ProblemsHolder holder) {
        JSAttributeList.AccessType accessType;
        PsiElement parent;
        if (!DialectDetector.isActionScript((PsiElement)node)) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
        if (fun != null) {
            return;
        }
        ASTNode nameIdentifier = node.findNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        JSClass clazz = JSResolveUtil.getClassOfContext((PsiElement)node);
        if (clazz == null && !((parent = JSResolveUtil.findParent((PsiElement)node)) instanceof JSPackageStatement)) {
            return;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)node).getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getAccessType() : null;
        if (accessType == JSAttributeList.AccessType.PACKAGE_LOCAL && attributeList.findAccessTypeElement() == null && attributeList.getNamespaceElement() == null && !JSResolveUtil.isConstructorFunction((PsiElement)node)) {
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("js.implicitly.internal.declaration.problem", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = FlexBundle.message("js.implicitly.internal.declaration.problem.add.internal.fix", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection$2", "getFamilyName"));
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection$2", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/actionscript/JSImplicitlyInternalDeclarationInspection$2", "applyFix"));
                    }
                    PsiElement anchor = descriptor.getPsiElement();
                    PsiFile containingFile = anchor.getContainingFile();
                    if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
                        return;
                    }
                    JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)((JSAttributeListOwner)anchor.getParent()), (JSAttributeList.AccessType)JSAttributeList.AccessType.PACKAGE_LOCAL);
                }
            }});
        }
    }
}

