/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.actionscript.fixes.ConvertToLocalFix;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFieldCanBeLocalInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance(JSFieldCanBeLocalInspection.class);

    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSFieldCanBeLocalInspection", "createVisitor"));
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("js.field.can.be.local.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/JSFieldCanBeLocalInspection", "getDisplayName"));
        }
        return string;
    }

    private static class MyVisitor
    extends JSElementVisitor {
        private final ProblemsHolder myHolder;

        public MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitJSVariable(JSVariable field) {
            if (!DialectDetector.isActionScript((PsiElement)field)) {
                return;
            }
            PsiElement parentParent = field.getParent().getParent();
            PsiElement context = parentParent.getContext();
            if (!(parentParent instanceof JSClass || parentParent instanceof JSFile && context instanceof XmlText && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)context.getContainingFile()))) {
                return;
            }
            JSAttributeList attributeList = field.getAttributeList();
            if (attributeList == null) {
                return;
            }
            if (attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE) {
                return;
            }
            if (field.isConst() && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return;
            }
            if (attributeList.findAttributeByName("Embed") != null || attributeList.findAttributeByName("Inject") != null) {
                return;
            }
            TreeMap<JSFunction, Collection<PsiReference>> functionToReferences = new TreeMap<JSFunction, Collection<PsiReference>>((f1, f2) -> f1.getTextRange().getStartOffset() - f2.getTextRange().getStartOffset());
            THashMap functionToFirstReadUsage = new THashMap();
            THashMap functionToFirstWriteUsage = new THashMap();
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)field.getProject()).getTopLevelFile((PsiElement)field);
            boolean ok = ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)topLevelFile)).forEach(arg_0 -> MyVisitor.lambda$visitJSVariable$1(functionToReferences, (Map)functionToFirstReadUsage, (Map)functionToFirstWriteUsage, arg_0));
            if (!ok) {
                return;
            }
            if (functionToFirstWriteUsage.isEmpty() && functionToFirstReadUsage.isEmpty()) {
                return;
            }
            boolean trivialInitializer = field.getInitializer() instanceof JSLiteralExpression;
            if (functionToFirstWriteUsage.isEmpty() && trivialInitializer) {
                this.registerCanBeLocal(field, functionToReferences);
                return;
            }
            for (Map.Entry entry : functionToFirstReadUsage.entrySet()) {
                JSFunction function = (JSFunction)entry.getKey();
                PsiElement readUsage = (PsiElement)entry.getValue();
                PsiElement writeUsage = (PsiElement)functionToFirstWriteUsage.get(function);
                if (writeUsage == null) {
                    return;
                }
                if (writeUsage.getTextRange().getStartOffset() >= readUsage.getTextRange().getStartOffset()) {
                    return;
                }
                JSElement branchingParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)writeUsage, (Class[])new Class[]{JSConditionalExpression.class, JSIfStatement.class, JSSwitchStatement.class});
                if (branchingParent != null) {
                    return;
                }
                PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)readUsage, (PsiElement)writeUsage);
                if (!(commonParent instanceof JSAssignmentExpression)) continue;
                return;
            }
            this.registerCanBeLocal(field, functionToReferences);
        }

        private void registerCanBeLocal(JSVariable field, Map<JSFunction, Collection<PsiReference>> functionToReferences) {
            LOG.assertTrue(!functionToReferences.isEmpty());
            PsiElement element = field.getNameIdentifier();
            if (element == null) {
                element = field;
            }
            LocalQuickFix[] fixes = new LocalQuickFix[]{new ConvertToLocalFix(field, functionToReferences)};
            this.myHolder.registerProblem(element, FlexBundle.message("js.field.can.be.converted.to.local", new Object[0]), fixes);
        }

        private static /* synthetic */ boolean lambda$visitJSVariable$1(SortedMap functionToReferences, Map functionToFirstReadUsage, Map functionToFirstWriteUsage, PsiReference reference) {
            PsiElement previous;
            PsiElement element = reference.getElement();
            if (JSResolveUtil.isSelfReference((PsiElement)element)) {
                return true;
            }
            if (!(element instanceof JSReferenceExpression)) {
                return false;
            }
            if (((JSReferenceExpression)element).getQualifier() != null) {
                return false;
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            if (function == null) {
                return false;
            }
            ArrayList<PsiReference> references = (ArrayList<PsiReference>)functionToReferences.get(function);
            if (references == null) {
                references = new ArrayList<PsiReference>();
                functionToReferences.put(function, references);
            }
            references.add(reference);
            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(element);
            if (!(access != ReadWriteAccessDetector.Access.Read && access != ReadWriteAccessDetector.Access.ReadWrite || (previous = (PsiElement)functionToFirstReadUsage.get(function)) != null && element.getTextRange().getStartOffset() >= previous.getTextRange().getStartOffset())) {
                functionToFirstReadUsage.put(function, element);
            }
            if (!(access != ReadWriteAccessDetector.Access.Write && access != ReadWriteAccessDetector.Access.ReadWrite || (previous = (PsiElement)functionToFirstWriteUsage.get(function)) != null && element.getTextRange().getStartOffset() >= previous.getTextRange().getStartOffset())) {
                functionToFirstWriteUsage.put(function, element);
            }
            return true;
        }
    }
}

