/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerProjectConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkAdditionalData;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexSdkUtils {
    public static final String ADL_RELATIVE_PATH = File.separatorChar + "bin" + File.separatorChar + "adl" + (SystemInfo.isWindows ? ".exe" : "");
    static final String AIR_RUNTIME_RELATIVE_PATH = File.separatorChar + "runtimes" + File.separatorChar + "air" + File.separatorChar + (SystemInfo.isWindows ? "win" : (SystemInfo.isLinux ? "linux" : "mac"));
    private static final Pattern PLAYER_FOLDER_PATTERN = Pattern.compile("\\d{1,2}(\\.\\d{1,2})?");

    private FlexSdkUtils() {
    }

    public static void processPlayerglobalSwcFiles(VirtualFile playerDir, Processor<VirtualFile> processor) {
        VirtualFile playerglobalSwcFile;
        VirtualFile subDir;
        VirtualFile[] children = playerDir.getChildren();
        VirtualFile[] sorted = Arrays.copyOf(children, children.length);
        Arrays.sort(sorted, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        VirtualFile[] virtualFileArray = sorted;
        int n = virtualFileArray.length;
        for (int i = 0; !(i >= n || (subDir = virtualFileArray[i]).isDirectory() && (playerglobalSwcFile = subDir.findChild("playerglobal.swc")) != null && PLAYER_FOLDER_PATTERN.matcher(subDir.getName()).matches() && !processor.process((Object)playerglobalSwcFile)); ++i) {
        }
    }

    @Nullable
    public static String doReadFlexSdkVersion(VirtualFile sdkRoot) {
        return FlexSdkUtils.doReadSdkVersion(sdkRoot, false);
    }

    @Nullable
    public static String doReadAirSdkVersion(VirtualFile sdkRoot) {
        return FlexSdkUtils.doReadSdkVersion(sdkRoot, true);
    }

    @Nullable
    private static String doReadSdkVersion(VirtualFile sdkRoot, boolean airSdk) {
        if (sdkRoot == null) {
            return null;
        }
        VirtualFile flexSdkDescriptionFile = sdkRoot.findChild(airSdk ? "air-sdk-description.xml" : "flex-sdk-description.xml");
        if (flexSdkDescriptionFile == null) {
            return null;
        }
        try {
            String versionElement = airSdk ? "<air-sdk-description><version>" : "<flex-sdk-description><version>";
            String buildElement = airSdk ? "<air-sdk-description><build>" : "<flex-sdk-description><build>";
            Map<String, List<String>> versionInfo = FlexUtils.findXMLElements(flexSdkDescriptionFile.getInputStream(), Arrays.asList(versionElement, buildElement));
            List<String> majorMinor = versionInfo.get(versionElement);
            List<String> revision = versionInfo.get(buildElement);
            return majorMinor.isEmpty() ? null : majorMinor.get(0) + (revision.isEmpty() ? "" : "." + revision.get(0));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static Sdk createOrGetSdk(SdkType sdkType, String path) {
        VirtualFile sdkHome;
        VirtualFile virtualFile = sdkHome = path == null ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (sdkHome == null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        for (Sdk flexSdk : projectJdkTable.getSdksOfType((SdkTypeId)sdkType)) {
            SdkAdditionalData data;
            String existingHome = flexSdk.getHomePath();
            if (existingHome == null || !sdkHome.getPath().equals(FileUtil.toSystemIndependentName((String)existingHome))) continue;
            if (sdkType instanceof FlexmojosSdkType && ((data = flexSdk.getSdkAdditionalData()) == null || ((FlexmojosSdkAdditionalData)data).getFlexCompilerClasspath().isEmpty())) {
                sdkType.setupSdkPaths(flexSdk);
            }
            return flexSdk;
        }
        return FlexSdkUtils.createSdk(sdkType, sdkHome.getPath());
    }

    private static Sdk createSdk(SdkType sdkType, @NotNull String sdkHomePath) {
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "createSdk"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return FlexSdkUtils.doCreateSdk(sdkType, sdkHomePath);
        }
        Ref sdkRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (sdkHomePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "lambda$createSdk$1"));
            }
            sdkRef.set((Object)FlexSdkUtils.doCreateSdk(sdkType, sdkHomePath));
        });
        return (Sdk)sdkRef.get();
    }

    private static Sdk doCreateSdk(final SdkType sdkType, final @NotNull String sdkHomePath) {
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "doCreateSdk"));
        }
        return (Sdk)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Sdk>(){

            public Sdk compute() {
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                String sdkName = SdkConfigurationUtil.createUniqueSdkName((SdkType)sdkType, (String)sdkHomePath, (Collection)projectJdkTable.getSdksOfType((SdkTypeId)sdkType));
                ProjectJdkImpl sdk = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType, sdkHomePath, "");
                sdkType.setupSdkPaths((Sdk)sdk);
                projectJdkTable.addJdk((Sdk)sdk);
                return sdk;
            }
        });
    }

    public static int getFlexSdkRevision(String sdkVersion) {
        try {
            int index = Math.max(sdkVersion.lastIndexOf(46), sdkVersion.lastIndexOf(32));
            return Integer.parseInt(sdkVersion.substring(index + 1));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String getAdlPath(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getAdlPath"));
        }
        if (sdk.getSdkType() instanceof FlexmojosSdkType && (data = sdk.getSdkAdditionalData()) instanceof FlexmojosSdkAdditionalData) {
            return ((FlexmojosSdkAdditionalData)data).getAdlPath();
        }
        return sdk.getHomePath() + ADL_RELATIVE_PATH;
    }

    public static String getAirRuntimePathForFlexmojosSdk(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getAirRuntimePathForFlexmojosSdk"));
        }
        assert (sdk.getSdkType() instanceof FlexmojosSdkType);
        if (sdk.getSdkType() instanceof FlexmojosSdkType && (data = sdk.getSdkAdditionalData()) instanceof FlexmojosSdkAdditionalData) {
            return ((FlexmojosSdkAdditionalData)data).getAirRuntimePath();
        }
        return sdk.getHomePath() + AIR_RUNTIME_RELATIVE_PATH;
    }

    @Nullable
    public static String getAirRuntimePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getAirRuntimePath"));
        }
        if (sdk.getSdkType() instanceof FlexmojosSdkType) {
            SdkAdditionalData data = sdk.getSdkAdditionalData();
            if (data instanceof FlexmojosSdkAdditionalData) {
                return ((FlexmojosSdkAdditionalData)data).getAirRuntimePath();
            }
        } else {
            return sdk.getHomePath() + AIR_RUNTIME_RELATIVE_PATH;
        }
        return null;
    }

    public static Pair<VirtualFile, Boolean> getAirRuntimeDirInfoForFlexmojosSdk(@NotNull Sdk sdk) throws IOException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getAirRuntimeDirInfoForFlexmojosSdk"));
        }
        assert (sdk.getSdkType() instanceof FlexmojosSdkType);
        String airRuntimePath = FlexSdkUtils.getAirRuntimePathForFlexmojosSdk(sdk);
        VirtualFile airRuntime = LocalFileSystem.getInstance().findFileByPath(airRuntimePath);
        if (airRuntime == null) {
            throw new IOException("Can't find AIR Runtime at " + airRuntimePath);
        }
        if (airRuntime.isDirectory()) {
            return Pair.create((Object)airRuntime, (Object)Boolean.FALSE);
        }
        String systemTempDirPath = FileUtil.getTempDirectory();
        File systemTempDir = new File(systemTempDirPath);
        if (!systemTempDir.exists() || !systemTempDir.isDirectory()) {
            throw new IOException("Temp directory doesn't exist: " + systemTempDirPath);
        }
        String tempDirPath = FlexSdkUtils.findUniqueTempDirName(systemTempDir);
        try {
            VirtualFile tempDir = FlexSdkUtils.unzip(airRuntime.getPath(), tempDirPath);
            return Pair.create((Object)tempDir, (Object)Boolean.TRUE);
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format("Can''t unzip file ''{0}'' to ''{1}'': {2}", FileUtil.toSystemDependentName((String)airRuntime.getPath()), tempDirPath, e.getMessage()));
        }
    }

    private static String findUniqueTempDirName(File systemTempDir) {
        String tempDirName;
        String unzipDirNameBase = "intellij_air_runtime_";
        String[] children = systemTempDir.list();
        int i = 1;
        while (ArrayUtil.contains((String)(tempDirName = "intellij_air_runtime_" + i), (String[])children)) {
            ++i;
        }
        return systemTempDir.getPath() + File.separatorChar + tempDirName;
    }

    @NotNull
    private static VirtualFile unzip(final String zipFilePath, final String outputDirPath) throws IOException {
        final Ref ioExceptionRef = new Ref();
        VirtualFile dir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    ZipUtil.extract((File)new File(zipFilePath), (File)new File(outputDirPath), null);
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(outputDirPath);
                    assert (tempDir != null);
                    return tempDir;
                }
                catch (IOException e) {
                    ioExceptionRef.set((Object)e);
                    return null;
                }
            }
        });
        if (!ioExceptionRef.isNull()) {
            throw (IOException)ioExceptionRef.get();
        }
        assert (dir != null);
        VirtualFile virtualFile = dir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "unzip"));
        }
        return virtualFile;
    }

    public static boolean isFlex2Sdk(@Nullable Sdk flexSdk) {
        String version = flexSdk == null ? null : flexSdk.getVersionString();
        return version != null && (version.startsWith("2.") || version.startsWith("3.0 Moxie"));
    }

    public static boolean isFlex3_0Sdk(@Nullable Sdk flexSdk) {
        String version = flexSdk == null ? null : flexSdk.getVersionString();
        return version != null && version.startsWith("3.0");
    }

    public static boolean isFlex4Sdk(@Nullable Sdk flexSdk) {
        String version = flexSdk == null ? null : flexSdk.getVersionString();
        return version != null && version.startsWith("4.");
    }

    public static List<String> getCommandLineForSdkTool(@NotNull Project project, @NotNull Sdk sdk, @Nullable String additionalClasspath, @NotNull String mainClass, @Nullable String jarName) {
        String vmOptions;
        boolean isFlexmojos;
        String classpath;
        int heapSizeMbFromJvmConfig;
        String additionalJavaArgs;
        boolean customJavaHomeSet;
        String javaHome;
        block24: {
            FlexmojosSdkAdditionalData flexmojosSdkData;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getCommandLineForSdkTool"));
            }
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getCommandLineForSdkTool"));
            }
            if (mainClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClass", "com/intellij/lang/javascript/flex/sdk/FlexSdkUtils", "getCommandLineForSdkTool"));
            }
            javaHome = SystemProperties.getJavaHome();
            customJavaHomeSet = false;
            additionalJavaArgs = null;
            heapSizeMbFromJvmConfig = 0;
            classpath = additionalClasspath;
            isFlexmojos = sdk.getSdkType() == FlexmojosSdkType.getInstance();
            FlexmojosSdkAdditionalData flexmojosSdkAdditionalData = flexmojosSdkData = isFlexmojos ? (FlexmojosSdkAdditionalData)sdk.getSdkAdditionalData() : null;
            if (isFlexmojos) {
                classpath = (StringUtil.isEmpty((String)classpath) ? "" : classpath + File.pathSeparator) + FileUtil.toSystemDependentName((String)StringUtil.join(flexmojosSdkData.getFlexCompilerClasspath(), (String)File.pathSeparator));
            } else {
                FileInputStream inputStream = null;
                try {
                    String classpathFromJvmConfig;
                    String javaArgs;
                    inputStream = new FileInputStream(FileUtil.toSystemDependentName((String)(sdk.getHomePath() + "/bin/jvm.config")));
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String configuredJavaHome = properties.getProperty("java.home");
                    if (configuredJavaHome != null && configuredJavaHome.trim().length() > 0) {
                        javaHome = configuredJavaHome;
                        customJavaHomeSet = true;
                    }
                    if ((javaArgs = properties.getProperty("java.args")) != null && javaArgs.trim().length() > 0) {
                        additionalJavaArgs = javaArgs;
                        Matcher matcher = FlexCommonUtils.XMX_PATTERN.matcher(javaArgs);
                        if (matcher.matches()) {
                            try {
                                heapSizeMbFromJvmConfig = Integer.parseInt(matcher.group(2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((classpathFromJvmConfig = properties.getProperty("java.class.path")) != null && classpathFromJvmConfig.trim().length() > 0) {
                        classpath = (StringUtil.isEmpty((String)classpath) ? "" : classpath + File.pathSeparator) + classpathFromJvmConfig;
                    }
                }
                catch (IOException e) {
                    if (inputStream == null) break block24;
                    try {
                        inputStream.close();
                    }
                    catch (IOException configuredJavaHome) {
                        // empty catch block
                    }
                }
            }
        }
        String javaExecutable = FileUtil.toSystemDependentName((String)(javaHome + "/bin/java" + (SystemInfo.isWindows ? ".exe" : "")));
        String applicationHomeParam = isFlexmojos ? null : "-Dapplication.home=" + FileUtil.toSystemDependentName((String)sdk.getHomePath());
        String d32 = FlexCommonUtils.getD32IfNeed((boolean)customJavaHomeSet, (String)javaHome);
        ArrayList<String> result = new ArrayList<String>();
        result.add(javaExecutable);
        if (StringUtil.isNotEmpty((String)d32)) {
            result.add(d32);
        }
        if (StringUtil.isNotEmpty((String)applicationHomeParam)) {
            result.add(applicationHomeParam);
        }
        if (StringUtil.isNotEmpty((String)additionalJavaArgs)) {
            result.addAll(StringUtil.split((String)additionalJavaArgs, (String)" "));
        }
        if (StringUtil.isNotEmpty((String)(vmOptions = FlexCompilerProjectConfiguration.getInstance((Project)project).VM_OPTIONS))) {
            result.addAll(StringUtil.split((String)vmOptions, (String)" "));
        }
        if (additionalJavaArgs == null || !additionalJavaArgs.contains("file.encoding")) {
            result.add("-Dfile.encoding=UTF-8");
        }
        result.add("-Djava.awt.headless=true");
        result.add("-Duser.language=en");
        result.add("-Duser.region=en");
        int heapSizeMb = FlexCompilerProjectConfiguration.getInstance((Project)project).HEAP_SIZE_MB;
        if (heapSizeMb > heapSizeMbFromJvmConfig) {
            result.add("-Xmx" + heapSizeMb + "m");
        }
        if (StringUtil.isNotEmpty((String)classpath)) {
            result.add("-classpath");
            result.add(classpath);
        }
        if (isFlexmojos || jarName == null) {
            result.add(mainClass);
        } else {
            result.add("-jar");
            result.add(FileUtil.toSystemDependentName((String)(sdk.getHomePath() + "/lib/" + jarName)));
        }
        return result;
    }

    public static void openModuleConfigurable(Module module) {
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance((Project)module.getProject());
        ShowSettingsUtil.getInstance().editConfigurable(module.getProject(), (Configurable)projectStructureConfigurable, () -> projectStructureConfigurable.select(module.getName(), ClasspathEditor.NAME, true));
    }

    public static void processStandardNamespaces(FlexBuildConfiguration bc, PairConsumer<String, String> processor) {
        Sdk sdk = bc.getSdk();
        if (bc.isPureAs() || sdk == null || sdk.getSdkType() == FlexmojosSdkType.getInstance()) {
            return;
        }
        if (StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4") < 0) {
            processor.consume((Object)"http://www.adobe.com/2006/mxml", (Object)"frameworks/mxml-manifest.xml");
        } else {
            processor.consume((Object)"http://ns.adobe.com/mxml/2009", (Object)"frameworks/mxml-2009-manifest.xml");
            if (bc.getTargetPlatform() == TargetPlatform.Mobile || bc.getDependencies().getComponentSet() == ComponentSet.SparkAndMx || bc.getDependencies().getComponentSet() == ComponentSet.SparkOnly) {
                processor.consume((Object)"library://ns.adobe.com/flex/spark", (Object)"frameworks/spark-manifest.xml");
            }
            if (bc.getTargetPlatform() != TargetPlatform.Mobile) {
                if (bc.getDependencies().getComponentSet() == ComponentSet.SparkAndMx || bc.getDependencies().getComponentSet() == ComponentSet.MxOnly) {
                    processor.consume((Object)"library://ns.adobe.com/flex/mx", (Object)"frameworks/mx-manifest.xml");
                }
                processor.consume((Object)"http://www.adobe.com/2006/mxml", (Object)"frameworks/mxml-manifest.xml");
            }
        }
    }

    public static Sdk[] getAllSdks() {
        FlexProjectConfigurationEditor currentEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        if (currentEditor == null) {
            return ProjectJdkTable.getInstance().getAllJdks();
        }
        Collection sdks = ProjectStructureConfigurable.getInstance((Project)currentEditor.getProject()).getProjectJdksModel().getProjectSdks().values();
        return sdks.toArray(new Sdk[sdks.size()]);
    }

    public static List<Sdk> getFlexAndFlexmojosSdks() {
        return ContainerUtil.filter((Object[])FlexSdkUtils.getAllSdks(), sdk -> sdk.getSdkType() instanceof FlexSdkType2 || sdk.getSdkType() instanceof FlexmojosSdkType);
    }

    @Nullable
    public static Sdk findFlexOrFlexmojosSdk(String name) {
        return (Sdk)ContainerUtil.find(FlexSdkUtils.getFlexAndFlexmojosSdks(), sdk -> name.equals(sdk.getName()));
    }

    public static List<Sdk> getFlexSdks() {
        return ContainerUtil.filter((Object[])FlexSdkUtils.getAllSdks(), sdk -> sdk.getSdkType() instanceof FlexSdkType2);
    }

    public static boolean isAirSdkWithoutFlex(@Nullable Sdk sdk) {
        String version = sdk == null ? null : sdk.getVersionString();
        return version != null && version.startsWith("AIR SDK ");
    }

    public static String getTargetPlayer(@Nullable String playerVersionInAnyForm, String sdkHome) {
        String targetPlayer = null;
        String[] targetPlayers = FlexCommonUtils.getTargetPlayers((String)sdkHome);
        if (playerVersionInAnyForm != null) {
            Trinity majorMinorRevision = FlexCommonUtils.getMajorMinorRevisionVersion((String)playerVersionInAnyForm);
            if (ArrayUtil.contains((String)((String)majorMinorRevision.first), (String[])targetPlayers)) {
                targetPlayer = (String)majorMinorRevision.first;
            } else if (ArrayUtil.contains((String)((String)majorMinorRevision.first + "." + (String)majorMinorRevision.second), (String[])targetPlayers)) {
                targetPlayer = (String)majorMinorRevision.first + "." + (String)majorMinorRevision.second;
            }
        }
        return targetPlayer != null ? targetPlayer : FlexCommonUtils.getMaximumVersion((String[])targetPlayers);
    }
}

