/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexRefactoringListenerProvider;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunConfigurationForm;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.run.FlexRunConfigRefactoringListener;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FlashRunConfiguration
extends LocatableConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption,
RefactoringListenerProvider {
    private FlashRunnerParameters myRunnerParameters = new FlashRunnerParameters();

    public FlashRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public FlashRunConfiguration clone() {
        FlashRunConfiguration clone = (FlashRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        FlashRunConfigurationForm flashRunConfigurationForm = new FlashRunConfigurationForm(this.getProject());
        if (flashRunConfigurationForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getConfigurationEditor"));
        }
        return flashRunConfigurationForm;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = new FlashRunnerParameters();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        FlexBuildConfiguration config;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getState"));
        }
        try {
            config = (FlexBuildConfiguration)this.myRunnerParameters.checkAndGetModuleAndBC((Project)this.getProject()).second;
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        BuildConfigurationNature nature = config.getNature();
        if (nature.isDesktopPlatform() || nature.isMobilePlatform() && this.myRunnerParameters.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.Emulator) {
            return new AirRunState(this.getProject(), env, this.myRunnerParameters);
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myRunnerParameters.check(this.getProject());
        this.myRunnerParameters.reportWarnings(this.getProject());
    }

    @NotNull
    public FlashRunnerParameters getRunnerParameters() {
        FlashRunnerParameters flashRunnerParameters = this.myRunnerParameters;
        if (flashRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getRunnerParameters"));
        }
        return flashRunnerParameters;
    }

    @NotNull
    public Module[] getModules() {
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getModules"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    public String suggestedName() {
        return this.myRunnerParameters.suggestName();
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (!this.myRunnerParameters.isOverrideMainClass()) {
            return null;
        }
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (!(element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement || module != null && module.equals(ModuleUtilCore.findModuleForPsiElement((PsiElement)element)))) {
            return null;
        }
        String currentPackage = StringUtil.getPackageName((String)this.myRunnerParameters.getOverriddenMainClass());
        if ((element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement) && Comparing.strEqual((String)FlexRefactoringListenerProvider.getPackageName(element), (String)currentPackage)) {
            return new FlexRunConfigRefactoringListener.PackageRefactoringListener((RunConfigurationBase)this);
        }
        if (element instanceof PsiDirectory && FlashRunConfiguration.containsClass(module, (PsiDirectory)element, this.myRunnerParameters.getOverriddenMainClass())) {
            return new FlexRunConfigRefactoringListener.PsiDirectoryRefactoringListener((RunConfigurationBase)this);
        }
        JSClass jsClass = FlexRefactoringListenerProvider.getJSClass(element);
        if (jsClass != null && Comparing.strEqual((String)jsClass.getQualifiedName(), (String)this.myRunnerParameters.getOverriddenMainClass())) {
            return new FlexRunConfigRefactoringListener.JSClassRefactoringListener((RunConfigurationBase)this);
        }
        return null;
    }

    public static boolean containsClass(Module module, PsiDirectory directory, String className) {
        String packageName = DirectoryIndex.getInstance((Project)module.getProject()).getPackageName(directory.getVirtualFile());
        if (!StringUtil.getPackageName((String)className).equals(packageName)) {
            return false;
        }
        PsiElement psiElement = ActionScriptClassResolver.findClassByQNameStatic(className, GlobalSearchScope.moduleScope((Module)module));
        return psiElement instanceof JSClass && directory.equals(psiElement.getContainingFile().getParent());
    }

    public static class AirRunState
    extends CommandLineState {
        private final Project myProject;
        private final BCBasedRunnerParameters myRunnerParameters;

        public AirRunState(Project project, ExecutionEnvironment env, BCBasedRunnerParameters runnerParameters) {
            super(env);
            this.myProject = project;
            this.myRunnerParameters = runnerParameters;
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            VirtualFile airRuntimeDirForFlexmojosSdk;
            boolean needToRemoveAirRuntimeDir;
            FlexBuildConfiguration bc;
            try {
                bc = (FlexBuildConfiguration)this.myRunnerParameters.checkAndGetModuleAndBC((Project)this.myProject).second;
            }
            catch (RuntimeConfigurationError e) {
                throw new ExecutionException(e.getMessage());
            }
            Sdk sdk = bc.getSdk();
            assert (sdk != null);
            if (sdk.getSdkType() instanceof FlexmojosSdkType) {
                Pair<VirtualFile, Boolean> airRuntimeDirInfo;
                try {
                    airRuntimeDirInfo = FlexSdkUtils.getAirRuntimeDirInfoForFlexmojosSdk(sdk);
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage());
                }
                needToRemoveAirRuntimeDir = (Boolean)airRuntimeDirInfo.second;
                airRuntimeDirForFlexmojosSdk = (VirtualFile)airRuntimeDirInfo.first;
            } else {
                needToRemoveAirRuntimeDir = false;
                airRuntimeDirForFlexmojosSdk = null;
            }
            String airRuntimePath = airRuntimeDirForFlexmojosSdk == null ? null : airRuntimeDirForFlexmojosSdk.getPath();
            OSProcessHandler processHandler = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)FlexBaseRunner.createAdlCommandLine(this.myProject, this.myRunnerParameters, bc, airRuntimePath));
            if (needToRemoveAirRuntimeDir && airRuntimeDirForFlexmojosSdk != null) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(ProcessEvent event) {
                        FlexUtils.removeFileLater(airRuntimeDirForFlexmojosSdk);
                    }
                });
            }
            OSProcessHandler oSProcessHandler = processHandler;
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfiguration$AirRunState", "startProcess"));
            }
            return oSProcessHandler;
        }
    }
}

