/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.BuildConfigurationProjectStructureElement;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.PlaceInBuildConfiguration;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import javax.swing.Icon;

public abstract class UsageInBcDependencies
extends ProjectStructureElementUsage {
    private final BuildConfigurationProjectStructureElement myContainingElement;
    private final ProjectStructureElement mySourceElement;

    public UsageInBcDependencies(BuildConfigurationProjectStructureElement containingElement, ProjectStructureElement sourceElement) {
        this.myContainingElement = containingElement;
        this.mySourceElement = sourceElement;
    }

    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    public ProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    public String getPresentableName() {
        return this.myContainingElement.getBC().getName();
    }

    public PlaceInProjectStructure getPlace() {
        if (this.mySourceElement instanceof LibraryProjectStructureElement) {
            Library library = ((LibraryProjectStructureElement)this.mySourceElement).getLibrary();
            DependenciesConfigurable.Location.TableEntry tableEntry = "module".equals(library.getTable().getTableLevel()) ? DependenciesConfigurable.Location.TableEntry.forModuleLibrary(FlexProjectRootsUtil.getLibraryId(library)) : DependenciesConfigurable.Location.TableEntry.forSharedLibrary(library);
            return new PlaceInBuildConfiguration(this.myContainingElement, DependenciesConfigurable.TAB_NAME, tableEntry);
        }
        if (this.mySourceElement instanceof BuildConfigurationProjectStructureElement) {
            BuildConfigurationProjectStructureElement bcElement = (BuildConfigurationProjectStructureElement)this.mySourceElement;
            String moduleName = bcElement.getModule().getName();
            String bcName = bcElement.getBC().getName();
            DependenciesConfigurable.Location.TableEntry tableEntry = DependenciesConfigurable.Location.TableEntry.forBc(moduleName, bcName);
            return new PlaceInBuildConfiguration(this.myContainingElement, DependenciesConfigurable.TAB_NAME, tableEntry);
        }
        if (this.mySourceElement instanceof SdkProjectStructureElement) {
            return new PlaceInBuildConfiguration(this.myContainingElement, DependenciesConfigurable.TAB_NAME, DependenciesConfigurable.Location.SDK);
        }
        assert (false) : this.mySourceElement;
        return null;
    }

    public int hashCode() {
        return this.myContainingElement.hashCode() & this.mySourceElement.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UsageInBcDependencies && ((UsageInBcDependencies)((Object)obj)).getContainingElement().equals((Object)this.getContainingElement()) && ((UsageInBcDependencies)((Object)obj)).getSourceElement().equals((Object)this.getSourceElement());
    }

    public Icon getIcon() {
        return this.myContainingElement.getBC().getIcon();
    }
}

