/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.projectStructure.ui.BuildConfigurationProjectStructureElement;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexProjectStructureUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceInBuildConfiguration
extends PlaceInProjectStructure {
    private final BuildConfigurationProjectStructureElement myStructureElement;
    private final String myTabName;
    @Nullable
    private final Object myLocationOnTab;

    public PlaceInBuildConfiguration(BuildConfigurationProjectStructureElement structureElement, @NotNull String tabName, @Nullable Object locationOnTab) {
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/lang/javascript/flex/projectStructure/ui/PlaceInBuildConfiguration", "<init>"));
        }
        this.myStructureElement = structureElement;
        this.myTabName = tabName;
        this.myLocationOnTab = locationOnTab;
    }

    @NotNull
    public ProjectStructureElement getContainingElement() {
        BuildConfigurationProjectStructureElement buildConfigurationProjectStructureElement = this.myStructureElement;
        if (buildConfigurationProjectStructureElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/PlaceInBuildConfiguration", "getContainingElement"));
        }
        return buildConfigurationProjectStructureElement;
    }

    public String getPlacePath() {
        return this.myTabName;
    }

    @NotNull
    public ActionCallback navigate() {
        if (this.myStructureElement.getModule().isDisposed()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/PlaceInBuildConfiguration", "navigate"));
            }
            return actionCallback;
        }
        Place place = FlexProjectStructureUtil.createPlace(this.myStructureElement.getModule(), this.myStructureElement.getBC(), this.myTabName);
        if (this.myLocationOnTab != null) {
            place.putPath("FlashBuildConfiguration.locationOnTab", this.myLocationOnTab);
        }
        ActionCallback actionCallback = ProjectStructureConfigurable.getInstance((Project)this.myStructureElement.getModule().getProject()).navigateTo(place, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/PlaceInBuildConfiguration", "navigate"));
        }
        return actionCallback;
    }
}

