/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.AirDescriptorOptions;
import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class CreateAirDescriptorTemplateDialog
extends DialogWrapper {
    public static final Pattern VERSION_PATTERN = Pattern.compile("[0-9]{1,3}(\\.[0-9]{1,3}){0,2}");
    private JPanel myMainPanel;
    private JTextField myDescriptorFileNameTextField;
    private TextFieldWithBrowseButton myDescriptorFolderTextWithBrowse;
    private JComboBox myAirVersionCombo;
    private JTextField myAppIdTextField;
    private JTextField myAppNameTextField;
    private JTextField myAppVersionTextField;
    private JPanel myMobileOptionsPanel;
    private JCheckBox myAndroidCheckBox;
    private JCheckBox myIOSCheckBox;
    private JCheckBox myAutoOrientCheckBox;
    private JCheckBox myFullScreenCheckBox;
    private JBTabbedPane myMobilePlatformsTabs;
    private JPanel myAndroidPanel;
    private JCheckBox myAndroidInternetCheckBox;
    private JCheckBox myAndroidWriteExternalStorageCheckBox;
    private JCheckBox myAndroidAccessFineLocationCheckBox;
    private JCheckBox myAndroidCameraCheckBox;
    private JPanel myIOSPanel;
    private JRadioButton myIOSAllRadioButton;
    private JRadioButton myIPhoneRadioButton;
    private JRadioButton myIPadRadioButton;
    private JCheckBox myIOSHighResolutionCheckBox;
    static final String TITLE = FlexBundle.message("create.air.descriptor.template.title", new Object[0]);
    private final Project myProject;
    private final String[] myExtensions;

    public CreateAirDescriptorTemplateDialog(Project project, String folderPath, String mainClass, String airVersion, String[] extensions, boolean androidEnabled, boolean iosEnabled) {
        super(project);
        this.myProject = project;
        this.myExtensions = extensions;
        this.$$$setupUI$$$();
        this.setTitle(TITLE);
        this.setOKButtonText("Create");
        this.initControls();
        this.init();
        String appName = StringUtil.getShortName((String)mainClass);
        this.myDescriptorFileNameTextField.setText(appName + "-app.xml");
        this.myDescriptorFolderTextWithBrowse.setText(FileUtil.toSystemDependentName((String)folderPath));
        this.myAirVersionCombo.setSelectedItem(airVersion);
        this.myAppIdTextField.setText(mainClass);
        this.myAppNameTextField.setText(appName);
        this.myAppVersionTextField.setText("0.0.0");
        this.myAndroidCheckBox.setSelected(androidEnabled);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myAndroidInternetCheckBox);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myAndroidWriteExternalStorageCheckBox);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myAndroidAccessFineLocationCheckBox);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myAndroidCameraCheckBox);
        this.myAndroidInternetCheckBox.setSelected(true);
        this.myAndroidWriteExternalStorageCheckBox.setSelected(false);
        this.myAndroidAccessFineLocationCheckBox.setSelected(false);
        this.myAndroidCameraCheckBox.setSelected(false);
        this.myIOSCheckBox.setSelected(iosEnabled);
        this.myIOSAllRadioButton.setSelected(true);
        this.myMobileOptionsPanel.setVisible(androidEnabled || iosEnabled);
        this.updateControls();
    }

    private void initControls() {
        this.myDescriptorFolderTextWithBrowse.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        String[] items = (String[])Arrays.copyOfRange(ArrayUtil.reverseArray((Object[])FlexApplicationComponent.AIR_VERSIONS), 0, 8);
        this.myAirVersionCombo.setModel(new DefaultComboBoxModel<String>(items));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateAirDescriptorTemplateDialog.this.updateControls();
            }
        };
        this.myAndroidCheckBox.addActionListener(listener);
        this.myIOSCheckBox.addActionListener(listener);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected ValidationInfo doValidate() {
        String fileName = this.myDescriptorFileNameTextField.getText().trim();
        if (fileName.isEmpty()) {
            return new ValidationInfo("Descriptor file name not set", (JComponent)this.myDescriptorFileNameTextField);
        }
        if (!fileName.toLowerCase().endsWith(".xml")) {
            return new ValidationInfo("Descriptor file name must have xml extension", (JComponent)this.myDescriptorFileNameTextField);
        }
        String folderPath = this.myDescriptorFolderTextWithBrowse.getText().trim();
        if (folderPath.isEmpty()) {
            return new ValidationInfo("Folder is not set", (JComponent)this.myDescriptorFolderTextWithBrowse);
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(folderPath);
        if (dir != null && !dir.isDirectory()) {
            return new ValidationInfo("Folder for AIR descriptor must be specified", (JComponent)this.myDescriptorFolderTextWithBrowse);
        }
        String airVersion = ((String)this.myAirVersionCombo.getSelectedItem()).trim();
        if (airVersion.isEmpty()) {
            return new ValidationInfo("AIR version is not set", (JComponent)this.myAirVersionCombo);
        }
        if (!VERSION_PATTERN.matcher(airVersion).matches()) {
            return new ValidationInfo("Incorrect AIR version", (JComponent)this.myAirVersionCombo);
        }
        String appId = this.myAppIdTextField.getText().trim();
        if (appId.isEmpty()) {
            return new ValidationInfo("Application ID is required", (JComponent)this.myAppIdTextField);
        }
        if (!appId.equals(FlexCommonUtils.fixApplicationId((String)appId))) {
            return new ValidationInfo("Application ID must contain only following symbols: 0-9, a-z, A-Z, '.', '-'", (JComponent)this.myAppIdTextField);
        }
        if (this.myAppNameTextField.getText().trim().isEmpty()) {
            return new ValidationInfo("Application name is required", (JComponent)this.myAppNameTextField);
        }
        String appVersion = this.myAppVersionTextField.getText().trim();
        if (appVersion.isEmpty()) {
            return new ValidationInfo("Application version is not set", (JComponent)this.myAppVersionTextField);
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"2.5") >= 0 && !VERSION_PATTERN.matcher(appVersion).matches()) {
            return new ValidationInfo("Application version must have following format: [0-999].[0-999].[0-999]", (JComponent)this.myAppVersionTextField);
        }
        return null;
    }

    private void updateControls() {
        UIUtil.setEnabled((Component)this.myMobilePlatformsTabs.getTabComponentAt(0), (boolean)this.myAndroidCheckBox.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myAndroidPanel, (boolean)this.myAndroidCheckBox.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myMobilePlatformsTabs.getTabComponentAt(1), (boolean)this.myIOSCheckBox.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myIOSPanel, (boolean)this.myIOSCheckBox.isSelected(), (boolean)true);
    }

    protected void doOKAction() {
        boolean android;
        String airVersion = ((String)this.myAirVersionCombo.getSelectedItem()).trim();
        String appId = this.myAppIdTextField.getText().trim();
        String appName = this.myAppNameTextField.getText().trim();
        String appVersion = this.myAppVersionTextField.getText().trim();
        String swfName = "SWF file name is set automatically at compile time";
        boolean mobile = this.myMobileOptionsPanel.isVisible();
        boolean autoOrients = mobile && this.myAutoOrientCheckBox.isSelected();
        boolean fullScreen = mobile && this.myFullScreenCheckBox.isSelected();
        boolean bl = android = mobile && this.myAndroidCheckBox.isSelected();
        int androidPermissions = !mobile || !android ? 0 : (this.myAndroidInternetCheckBox.isSelected() ? 1 : 0) | (this.myAndroidWriteExternalStorageCheckBox.isSelected() ? 2 : 0) | (this.myAndroidAccessFineLocationCheckBox.isSelected() ? 4 : 0) | (this.myAndroidCameraCheckBox.isSelected() ? 8 : 0);
        boolean ios = mobile && this.myIOSCheckBox.isSelected();
        boolean iPhone = mobile && ios && (this.myIOSAllRadioButton.isSelected() || this.myIPhoneRadioButton.isSelected());
        boolean iPad = mobile && ios && (this.myIOSAllRadioButton.isSelected() || this.myIPadRadioButton.isSelected());
        boolean iosHighResolution = mobile && ios && this.myIOSHighResolutionCheckBox.isSelected();
        AirDescriptorOptions options = new AirDescriptorOptions(airVersion, appId, appName, appVersion, "SWF file name is set automatically at compile time", this.myExtensions, mobile, autoOrients, fullScreen, android, androidPermissions, ios, iPhone, iPad, iosHighResolution);
        if (CreateAirDescriptorTemplateDialog.createAirDescriptorTemplate(this.myProject, true, this.getDescriptorPath(), options) != null) {
            super.doOKAction();
        }
    }

    @Nullable
    private static VirtualFile createAirDescriptorTemplate(Project project, boolean interactive, String descriptorPath, final AirDescriptorOptions options) {
        final VirtualFile dir = FlexUtils.createDirIfMissing(project, interactive, PathUtil.getParentPath((String)descriptorPath), TITLE);
        if (dir == null) {
            return null;
        }
        final String fileName = PathUtil.getFileName((String)descriptorPath);
        VirtualFile file = dir.findChild(fileName);
        if (file != null) {
            int choice;
            if (file.isDirectory()) {
                if (interactive) {
                    Messages.showErrorDialog((Project)project, (String)"Can't create AIR descriptor file.\nFolder with such name exists.", (String)TITLE);
                }
                return null;
            }
            int n = choice = interactive ? Messages.showYesNoDialog((Project)project, (String)FlexBundle.message("file.exists.replace.question", fileName), (String)TITLE, (Icon)Messages.getQuestionIcon()) : 0;
            if (choice != 0) {
                return null;
            }
        }
        try {
            final Ref fileRef = new Ref();
            IOException exception = (IOException)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<IOException>(){

                public IOException compute() {
                    try {
                        fileRef.set((Object)FlexUtils.addFileWithContent(fileName, options.getAirDescriptorText(), dir));
                    }
                    catch (IOException e) {
                        return e;
                    }
                    return null;
                }
            });
            if (exception != null) {
                throw exception;
            }
            return (VirtualFile)fileRef.get();
        }
        catch (IOException e) {
            if (interactive) {
                Messages.showErrorDialog((Project)project, (String)("Failed to create AIR descriptor file: " + e.getMessage()), (String)TITLE);
            }
            return null;
        }
    }

    public String getDescriptorPath() {
        return FileUtil.toSystemIndependentName((String)(this.myDescriptorFolderTextWithBrowse.getText().trim() + "/" + this.myDescriptorFileNameTextField.getText().trim()));
    }

    public boolean isBothAndroidAndIosSelected() {
        return this.myAndroidCheckBox.isVisible() && this.myAndroidCheckBox.isSelected() && this.myIOSCheckBox.isVisible() && this.myIOSCheckBox.isSelected();
    }

    protected String getHelpId() {
        return "flex.CreateAirDescriptorTemplateDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        JBTabbedPane jBTabbedPane;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMobileOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Mobile options", (int)0, (int)0, null, null));
        this.myAutoOrientCheckBox = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Auto-orient");
        jCheckBox9.setSelected(true);
        jPanel3.add((Component)jCheckBox9, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFullScreenCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Full screen");
        jCheckBox8.setSelected(true);
        jPanel3.add((Component)jCheckBox8, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMobilePlatformsTabs = jBTabbedPane = new JBTabbedPane();
        jPanel3.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 4, 0, 1, 3, 3, null, null, null));
        this.myAndroidPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Android", null, jPanel2, null);
        JLabel jLabel = new JLabel();
        jLabel.setText("Permissions:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAndroidCameraCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("CAMERA");
        jCheckBox7.setSelected(true);
        jPanel2.add((Component)jCheckBox7, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAndroidAccessFineLocationCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("ACCESS_FINE_LOCATION");
        jCheckBox6.setSelected(true);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAndroidWriteExternalStorageCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("WRITE_EXTERNAL_STORAGE");
        jCheckBox5.setSelected(true);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAndroidInternetCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("INTERNET");
        jCheckBox4.setSelected(true);
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIOSPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("iOS", null, jPanel, null);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIOSAllRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("All");
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Devices:");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIOSHighResolutionCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("High resolution");
        jCheckBox3.setSelected(true);
        jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myIPhoneRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("iPhone/iPod touch");
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIPadRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("iPad");
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Common options:");
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Mobile platform:");
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAndroidCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Android");
        jCheckBox2.setSelected(true);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIOSCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("iOS");
        jCheckBox.setSelected(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Application properties", (int)0, (int)0, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("ID:");
        jLabel5.setDisplayedMnemonic('I');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppIdTextField = jTextField4 = new JTextField();
        jTextField4.setText("");
        jPanel6.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Name:");
        jLabel6.setDisplayedMnemonic('A');
        jLabel6.setDisplayedMnemonicIndex(1);
        jPanel6.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppNameTextField = jTextField3 = new JTextField();
        jTextField3.setToolTipText("The name that is displayed in the AIR application installer");
        jTextField3.setText("");
        jPanel6.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myAppVersionTextField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel6.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Version:");
        jLabel7.setDisplayedMnemonic('E');
        jLabel7.setDisplayedMnemonicIndex(1);
        jPanel6.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"AIR application descriptor", (int)0, (int)0, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("File name:");
        jLabel8.setDisplayedMnemonic('N');
        jLabel8.setDisplayedMnemonicIndex(5);
        jPanel7.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescriptorFileNameTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Folder:");
        jLabel9.setDisplayedMnemonic('F');
        jLabel9.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescriptorFolderTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, new Dimension(300, -1), null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("AIR version:");
        jLabel10.setDisplayedMnemonic('V');
        jLabel10.setDisplayedMnemonicIndex(4);
        jPanel7.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAirVersionCombo = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel7.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel4.add((Component)spacer7, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel4.add((Component)spacer8, new GridConstraints(3, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel4.add((Component)spacer9, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel5.setLabelFor(jTextField4);
        jLabel6.setLabelFor(jTextField3);
        jLabel7.setLabelFor(jTextField2);
        jLabel8.setLabelFor(jTextField);
        jLabel9.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel10.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

