/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableIosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirDescriptorForm;
import com.intellij.lang.javascript.flex.projectStructure.ui.CreateAirDescriptorTemplateDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.FilesToPackageForm;
import com.intellij.lang.javascript.flex.projectStructure.ui.SigningOptionsForm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AirPackagingConfigurableBase<T extends ModifiableAirPackagingOptions>
extends NamedConfigurable<T>
implements Place.Navigator {
    private JPanel myMainPanel;
    private JCheckBox myEnabledCheckBox;
    private AirDescriptorForm myAirDescriptorForm;
    private JTextField myPackageFileNameTextField;
    private FilesToPackageForm myFilesToPackageForm;
    private SigningOptionsForm mySigningOptionsForm;
    private final Module myModule;
    private final T myModel;
    private final boolean isAndroid;
    private final boolean isIOS;
    private final AirDescriptorInfoProvider myAirDescriptorInfoProvider;
    private final Disposable myDisposable;
    private final EventDispatcher<UserActivityListener> myUserActivityDispatcher;
    private boolean myFreeze;

    public AirPackagingConfigurableBase(Module module, T model, AirDescriptorInfoProvider airDescriptorInfoProvider) {
        this.myModule = module;
        this.myModel = model;
        this.myAirDescriptorInfoProvider = airDescriptorInfoProvider;
        this.isAndroid = model instanceof ModifiableAndroidPackagingOptions;
        this.isIOS = model instanceof ModifiableIosPackagingOptions;
        this.$$$setupUI$$$();
        this.myEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirPackagingConfigurableBase.this.updateControls();
            }
        });
        this.myDisposable = Disposer.newDisposable();
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myMainPanel);
        this.myUserActivityDispatcher = EventDispatcher.create(UserActivityListener.class);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                if (AirPackagingConfigurableBase.this.myFreeze) {
                    return;
                }
                ((UserActivityListener)AirPackagingConfigurableBase.this.myUserActivityDispatcher.getMulticaster()).stateChanged();
            }
        }, this.myDisposable);
    }

    public void addUserActivityListener(UserActivityListener listener, Disposable disposable) {
        this.myUserActivityDispatcher.addListener((EventListener)listener, disposable);
    }

    public void removeUserActivityListeners() {
        for (UserActivityListener listener : this.myUserActivityDispatcher.getListeners()) {
            this.myUserActivityDispatcher.removeListener((EventListener)listener);
        }
    }

    private void updateControls() {
        boolean enabled = this.isPackagingEnabled();
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
        this.myEnabledCheckBox.setEnabled(true);
        this.myAirDescriptorForm.updateControls();
        this.mySigningOptionsForm.setEnabled(enabled);
    }

    public T getEditableObject() {
        return this.myModel;
    }

    public void setDisplayName(String name) {
    }

    public String getBannerSlogan() {
        return this.getDisplayName();
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    public void reset() {
        this.myFreeze = true;
        try {
            this.myEnabledCheckBox.setVisible(this.isAndroid || this.isIOS);
            if (this.isAndroid) {
                this.myEnabledCheckBox.setSelected(((AndroidPackagingOptions)this.myModel).isEnabled());
            }
            if (this.isIOS) {
                this.myEnabledCheckBox.setSelected(((IosPackagingOptions)this.myModel).isEnabled());
            }
            this.myAirDescriptorForm.resetFrom((AirPackagingOptions)this.myModel);
            this.myPackageFileNameTextField.setText(this.myModel.getPackageFileName());
            this.myFilesToPackageForm.resetFrom(this.myModel.getFilesToPackage());
            this.mySigningOptionsForm.resetFrom(this.myModel.getSigningOptions());
            this.updateControls();
        }
        finally {
            this.myFreeze = false;
        }
    }

    public boolean isModified() {
        if (this.isAndroid && this.myEnabledCheckBox.isSelected() != ((AndroidPackagingOptions)this.myModel).isEnabled()) {
            return true;
        }
        if (this.isIOS && this.myEnabledCheckBox.isSelected() != ((IosPackagingOptions)this.myModel).isEnabled()) {
            return true;
        }
        if (this.myAirDescriptorForm.isModified((ModifiableAirPackagingOptions)this.myModel)) {
            return true;
        }
        if (!this.myModel.getPackageFileName().equals(this.myPackageFileNameTextField.getText().trim())) {
            return true;
        }
        if (this.myFilesToPackageForm.isModified(this.myModel.getFilesToPackage())) {
            return true;
        }
        return this.mySigningOptionsForm.isModified(this.myModel.getSigningOptions());
    }

    public void apply() throws ConfigurationException {
        this.applyTo((ModifiableAirPackagingOptions)this.myModel);
    }

    public void applyTo(ModifiableAirPackagingOptions model) {
        if (this.isAndroid) {
            ((ModifiableAndroidPackagingOptions)model).setEnabled(this.myEnabledCheckBox.isSelected());
        }
        if (this.isIOS) {
            ((ModifiableIosPackagingOptions)model).setEnabled(this.myEnabledCheckBox.isSelected());
        }
        this.myAirDescriptorForm.applyTo(model);
        model.setPackageFileName(this.myPackageFileNameTextField.getText().trim());
        model.setFilesToPackage(this.myFilesToPackageForm.getFilesToPackage());
        this.mySigningOptionsForm.applyTo(model.getSigningOptions());
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void createUIComponents() {
        Runnable descriptorCreator = () -> {
            String folderPath = FlexUtils.getContentOrModuleFolderPath(this.myModule);
            String mainClass = this.myAirDescriptorInfoProvider.getMainClass();
            String airVersion = this.myAirDescriptorInfoProvider.getAirVersion();
            String[] extensions = this.myAirDescriptorInfoProvider.getExtensionIDs();
            boolean androidEnabled = this.myAirDescriptorInfoProvider.isAndroidPackagingEnabled();
            boolean iosEnabled = this.myAirDescriptorInfoProvider.isIOSPackagingEnabled();
            CreateAirDescriptorTemplateDialog dialog = new CreateAirDescriptorTemplateDialog(this.myModule.getProject(), folderPath, mainClass, airVersion, extensions, androidEnabled, iosEnabled);
            if (dialog.showAndGet()) {
                int choice;
                String descriptorPath = dialog.getDescriptorPath();
                this.setUseCustomDescriptor(descriptorPath);
                if (androidEnabled && iosEnabled && dialog.isBothAndroidAndIosSelected() && (choice = Messages.showYesNoDialog((Project)this.myModule.getProject(), (String)FlexBundle.message("use.same.descriptor.for.android.and.ios", new Object[0]), (String)CreateAirDescriptorTemplateDialog.TITLE, (Icon)Messages.getQuestionIcon())) == 0) {
                    this.myAirDescriptorInfoProvider.setCustomDescriptorForAndroidAndIOS(descriptorPath);
                }
            }
        };
        this.myAirDescriptorForm = new AirDescriptorForm(this.myModule.getProject(), descriptorCreator);
        this.myFilesToPackageForm = new FilesToPackageForm(this.myModule.getProject());
        SigningOptionsForm.Mode mode = this.isIOS ? SigningOptionsForm.Mode.iOS : (this.isAndroid ? SigningOptionsForm.Mode.Android : SigningOptionsForm.Mode.Desktop);
        this.mySigningOptionsForm = new SigningOptionsForm(this.myModule.getProject(), mode);
    }

    public void setUseCustomDescriptor(String descriptorPath) {
        this.myAirDescriptorForm.setUseCustomDescriptor(descriptorPath);
    }

    public boolean isPackagingEnabled() {
        return !this.myEnabledCheckBox.isVisible() || this.myEnabledCheckBox.isSelected();
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object location;
        if (place != null && (location = place.getPath("FlashBuildConfiguration.locationOnTab")) instanceof Location) {
            switch ((Location)((Object)location)) {
                case CustomDescriptor: {
                    return this.myAirDescriptorForm.navigateTo((Location)((Object)location));
                }
                case PackageFileName: {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.myPackageFileNameTextField, true);
                }
                case FilesToPackage: {
                    return this.myFilesToPackageForm.navigateTo((Location)((Object)location));
                }
                case ProvisioningProfile: 
                case Keystore: 
                case IosSdkPath: {
                    return this.mySigningOptionsForm.navigateTo((Location)((Object)location));
                }
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/projectStructure/ui/AirPackagingConfigurableBase", "queryPlace"));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        FilesToPackageForm filesToPackageForm = this.myFilesToPackageForm;
        JComponent jComponent = filesToPackageForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        SigningOptionsForm signingOptionsForm = this.mySigningOptionsForm;
        JComponent jComponent2 = signingOptionsForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        AirDescriptorForm airDescriptorForm = this.myAirDescriptorForm;
        JComponent jComponent3 = airDescriptorForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Package file name (without extension):");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageFileNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(200, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEnabledCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enabled");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface AirDescriptorInfoProvider {
        public String getMainClass();

        public String getAirVersion();

        public String[] getExtensionIDs();

        public boolean isAndroidPackagingEnabled();

        public boolean isIOSPackagingEnabled();

        public void setCustomDescriptorForAndroidAndIOS(String var1);
    }

    public static enum Location {
        CustomDescriptor("custom-descriptor-path"),
        PackageFileName("package-file-name"),
        FilesToPackage("files-to-package"),
        ProvisioningProfile("provisioning-profile"),
        Keystore("keystore"),
        IosSdkPath("ios-sdk-path");

        public final String errorId;

        private Location(String errorId) {
            this.errorId = errorId;
        }
    }
}

