/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class SdkEntryImpl
implements SdkEntry {
    @NotNull
    private final String myName;
    private final LinkedHashMap<String, DependencyTypeImpl> myDependencyTypes;

    public SdkEntryImpl(State state) {
        this.myDependencyTypes = new LinkedHashMap();
        this.myName = StringUtil.notNullize((String)state.NAME);
        for (EntryState entryState : state.DEPENDENCY_TYPES) {
            DependencyTypeImpl dependencyType = new DependencyTypeImpl();
            dependencyType.loadState(entryState.TYPE);
            this.myDependencyTypes.put((Object)entryState.URL, (Object)dependencyType);
        }
    }

    public SdkEntryImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SdkEntryImpl", "<init>"));
        }
        this.myDependencyTypes = new LinkedHashMap();
        this.myName = name;
    }

    public SdkEntryImpl getCopy() {
        SdkEntryImpl copy = new SdkEntryImpl(this.myName);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(SdkEntryImpl copy) {
        copy.myDependencyTypes.clear();
        copy.myDependencyTypes.putAll(this.myDependencyTypes);
    }

    public boolean isEqual(@NotNull SdkEntryImpl that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SdkEntryImpl", "isEqual"));
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        Iterator i1 = this.myDependencyTypes.keySet().iterator();
        Iterator i2 = that.myDependencyTypes.keySet().iterator();
        while (i1.hasNext() && i2.hasNext()) {
            String url2;
            String url1 = (String)i1.next();
            if (!url1.equals(url2 = (String)i2.next())) {
                return true;
            }
            if (Comparing.equal((Object)this.myDependencyTypes.get((Object)url1), (Object)this.myDependencyTypes.get((Object)url2))) continue;
            return true;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SdkEntryImpl", "getName"));
        }
        return string;
    }

    public State getState() {
        State state = new State();
        state.NAME = this.myName;
        for (Map.Entry entry : this.myDependencyTypes.entrySet()) {
            EntryState entryState = new EntryState();
            entryState.URL = (String)entry.getKey();
            entryState.TYPE = ((DependencyTypeImpl)entry.getValue()).getState();
            state.DEPENDENCY_TYPES.add(entryState);
        }
        return state;
    }

    @Tag(value="entry")
    public static class EntryState {
        @Attribute(value="url")
        public String URL;
        @Property(surroundWithTag=false)
        public DependencyTypeImpl.State TYPE;
    }

    @Tag(value="sdk")
    public static class State {
        @Attribute(value="name")
        public String NAME;
        @Tag(value="dependencies")
        public List<EntryState> DEPENDENCY_TYPES = new ArrayList<EntryState>();
    }
}

