/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.ModuleLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SharedLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ConversionHelper {
    public static ModifiableBuildConfigurationEntry createBuildConfigurationEntry(String moduleName, String bcName) {
        return new LightweightBuildConfigurationEntry(moduleName, bcName);
    }

    public static FlexBuildConfigurationManagerImpl createBuildConfigurationManager() {
        FlexBuildConfigurationManagerImpl m = new FlexBuildConfigurationManagerImpl(null);
        m.setActiveBuildConfiguration(m.getBuildConfigurations()[0]);
        return m;
    }

    public static ModifiableFlexBuildConfiguration createBuildConfiguration(FlexBuildConfigurationManagerImpl m) {
        Object[] configurations = m.doGetBuildConfigurations();
        FlexBuildConfigurationImpl result = new FlexBuildConfigurationImpl();
        m.doSetBuildConfigurations((FlexBuildConfigurationImpl[])ArrayUtil.append((Object[])configurations, (Object)result));
        return result;
    }

    public static ModifiableModuleLibraryEntry createModuleLibraryEntry(String libraryId) {
        return new ModuleLibraryEntryImpl(libraryId);
    }

    public static ModifiableSharedLibraryEntry createSharedLibraryEntry(String libraryName, String libraryLevel) {
        return new SharedLibraryEntryImpl(libraryName, libraryLevel);
    }

    public static Element serialize(PersistentStateComponent c) {
        Element element = XmlSerializer.serialize((Object)c.getState(), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        ConversionHelper.collapsePaths(element);
        return element;
    }

    public static void collapsePaths(Element element) {
        ReplacePathToMacroMap map = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(map);
        map.substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    public static void expandPaths(Element element) {
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        PathMacrosImpl.getInstanceEx().addMacroExpands(map);
        map.substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    private static class LightweightBuildConfigurationEntry
    implements BuildConfigurationEntry,
    ModifiableBuildConfigurationEntry,
    StatefulDependencyEntry {
        private final DependencyTypeImpl myDependencyType;
        @NotNull
        private final String myModuleName;
        @NotNull
        private final String myBcName;

        private LightweightBuildConfigurationEntry(@NotNull String moduleName, @NotNull String bcName) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ConversionHelper$LightweightBuildConfigurationEntry", "<init>"));
            }
            if (bcName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ConversionHelper$LightweightBuildConfigurationEntry", "<init>"));
            }
            this.myDependencyType = new DependencyTypeImpl();
            this.myModuleName = moduleName;
            this.myBcName = bcName;
        }

        @Override
        @NotNull
        public String getBcName() {
            String string = this.myBcName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ConversionHelper$LightweightBuildConfigurationEntry", "getBcName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getModuleName() {
            String string = this.myModuleName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ConversionHelper$LightweightBuildConfigurationEntry", "getModuleName"));
            }
            return string;
        }

        @Override
        public Module findModule() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FlexBuildConfiguration findBuildConfiguration() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ModifiableDependencyType getDependencyType() {
            DependencyTypeImpl dependencyTypeImpl = this.myDependencyType;
            if (dependencyTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ConversionHelper$LightweightBuildConfigurationEntry", "getDependencyType"));
            }
            return dependencyTypeImpl;
        }

        @Override
        public EntryState getState() {
            EntryState state = new EntryState();
            state.MODULE_NAME = this.getModuleName();
            state.BC_NAME = this.myBcName;
            state.DEPENDENCY_TYPE = this.myDependencyType.getState();
            return state;
        }

        @Override
        public boolean isEqual(ModifiableDependencyEntry other) {
            if (!(other instanceof LightweightBuildConfigurationEntry)) {
                return false;
            }
            if (!this.myBcName.equals(((LightweightBuildConfigurationEntry)other).myBcName)) {
                return false;
            }
            if (!this.getModuleName().equals(((LightweightBuildConfigurationEntry)other).myModuleName)) {
                return false;
            }
            return this.myDependencyType.isEqual(((LightweightBuildConfigurationEntry)other).myDependencyType);
        }
    }
}

