/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptionsListener;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleOrProjectCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompilerOptionsImpl
implements ModifiableCompilerOptions,
ModuleOrProjectCompilerOptions {
    private final Project myProject;
    private final boolean myResetHighlightingOnCommit;
    private final EventDispatcher<CompilerOptionsListener> myDispatcher = EventDispatcher.create(CompilerOptionsListener.class);
    private final Map<String, String> myOptions = new THashMap();
    @NotNull
    private CompilerOptions.ResourceFilesMode myResourceFilesMode = CompilerOptions.ResourceFilesMode.All;
    @NotNull
    private String myFilesToIncludeInSWC = "";
    @NotNull
    private String myAdditionalConfigFilePath = "";
    @NotNull
    private String myAdditionalOptions = "";

    CompilerOptionsImpl() {
        this(null, false);
    }

    CompilerOptionsImpl(Project project, boolean resetHighlightingOnCommit) {
        this.myProject = project;
        this.myResetHighlightingOnCommit = resetHighlightingOnCommit;
    }

    @Override
    public void addOptionsListener(CompilerOptionsListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    @Nullable
    public String getOption(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "getOption"));
        }
        return this.myOptions.get(name);
    }

    @Override
    public Map<String, String> getAllOptions() {
        return Collections.unmodifiableMap(this.myOptions);
    }

    @Override
    public void setAllOptions(Map<String, String> newOptions) {
        this.myOptions.clear();
        this.myOptions.putAll(newOptions);
        if (this.myResetHighlightingOnCommit) {
            FlexCompilerHandler.getInstance(this.myProject).getCompilerDependenciesCache().clear();
            ApplicationManager.getApplication().runWriteAction(() -> FlexBuildConfigurationManagerImpl.resetHighlighting(this.myProject));
            ((CompilerOptionsListener)this.myDispatcher.getMulticaster()).optionsInTableChanged();
        }
    }

    @Override
    public void setResourceFilesMode(@NotNull CompilerOptions.ResourceFilesMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "setResourceFilesMode"));
        }
        this.myResourceFilesMode = mode;
    }

    @Override
    @NotNull
    public CompilerOptions.ResourceFilesMode getResourceFilesMode() {
        CompilerOptions.ResourceFilesMode resourceFilesMode = this.myResourceFilesMode;
        if (resourceFilesMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "getResourceFilesMode"));
        }
        return resourceFilesMode;
    }

    @Override
    public Collection<String> getFilesToIncludeInSWC() {
        if (this.myFilesToIncludeInSWC.isEmpty()) {
            return Collections.emptyList();
        }
        return StringUtil.split((String)this.myFilesToIncludeInSWC, (String)"\n");
    }

    @Override
    public void setFilesToIncludeInSWC(@NotNull Collection<String> filesToIncludeInSWC) {
        if (filesToIncludeInSWC == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToIncludeInSWC", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "setFilesToIncludeInSWC"));
        }
        this.myFilesToIncludeInSWC = filesToIncludeInSWC.isEmpty() ? "" : StringUtil.join(filesToIncludeInSWC, (String)"\n");
    }

    @Override
    public void setAdditionalConfigFilePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "setAdditionalConfigFilePath"));
        }
        this.myAdditionalConfigFilePath = path;
        if (this.myResetHighlightingOnCommit) assert (this.myAdditionalConfigFilePath.equals(path));
    }

    @Override
    @NotNull
    public String getAdditionalConfigFilePath() {
        String string = this.myAdditionalConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "getAdditionalConfigFilePath"));
        }
        return string;
    }

    @Override
    public void setAdditionalOptions(@NotNull String options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "setAdditionalOptions"));
        }
        this.myAdditionalOptions = options;
        if (this.myResetHighlightingOnCommit) {
            FlexCompilerHandler.getInstance(this.myProject).getCompilerDependenciesCache().clear();
            ApplicationManager.getApplication().runWriteAction(() -> FlexBuildConfigurationManagerImpl.resetHighlighting(this.myProject));
            ((CompilerOptionsListener)this.myDispatcher.getMulticaster()).additionalOptionsChanged();
        }
    }

    @Override
    @NotNull
    public String getAdditionalOptions() {
        String string = this.myAdditionalOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/CompilerOptionsImpl", "getAdditionalOptions"));
        }
        return string;
    }

    public CompilerOptionsImpl getCopy() {
        CompilerOptionsImpl copy = new CompilerOptionsImpl();
        this.applyTo(copy);
        return copy;
    }

    void applyTo(ModifiableCompilerOptions copy) {
        copy.setAllOptions(this.myOptions);
        copy.setResourceFilesMode(this.myResourceFilesMode);
        ((CompilerOptionsImpl)copy).myFilesToIncludeInSWC = this.myFilesToIncludeInSWC;
        copy.setAdditionalConfigFilePath(this.myAdditionalConfigFilePath);
        copy.setAdditionalOptions(this.myAdditionalOptions);
    }

    public State getState(@Nullable ComponentManager componentManager) {
        State state = new State();
        CompilerOptionsImpl.putOptionsCollapsingPaths(this.myOptions, state.options, componentManager);
        state.resourceFilesMode = this.myResourceFilesMode;
        state.filesToIncludeInSWC = FlexBuildConfigurationImpl.collapsePaths(componentManager, this.myFilesToIncludeInSWC);
        state.additionalConfigFilePath = this.myAdditionalConfigFilePath;
        state.additionalOptions = this.myAdditionalOptions;
        return state;
    }

    private static void putOptionsCollapsingPaths(Map<String, String> fromMap, Map<String, String> toMap, @Nullable ComponentManager componentManager) {
        for (Map.Entry<String, String> entry : fromMap.entrySet()) {
            toMap.put(entry.getKey(), FlexBuildConfigurationImpl.collapsePaths(componentManager, entry.getValue()));
        }
    }

    public void loadState(State state) {
        this.myOptions.clear();
        for (Map.Entry<String, String> entry : state.options.entrySet()) {
            if (!CompilerOptionInfo.idExists((String)entry.getKey())) continue;
            this.myOptions.put(entry.getKey(), entry.getValue());
        }
        this.myResourceFilesMode = state.resourceFilesMode;
        this.myFilesToIncludeInSWC = state.filesToIncludeInSWC;
        this.myAdditionalConfigFilePath = state.additionalConfigFilePath;
        this.myAdditionalOptions = state.additionalOptions;
    }

    public boolean isEqual(CompilerOptionsImpl other) {
        return this.myOptions.equals(other.myOptions) && this.myResourceFilesMode == other.myResourceFilesMode && this.myFilesToIncludeInSWC.equals(other.myFilesToIncludeInSWC) && this.myAdditionalConfigFilePath.equals(other.myAdditionalConfigFilePath) && this.myAdditionalOptions.equals(other.myAdditionalOptions);
    }

    @Tag(value="compiler-options")
    public static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, String> options = new THashMap();
        public CompilerOptions.ResourceFilesMode resourceFilesMode = CompilerOptions.ResourceFilesMode.All;
        public String filesToIncludeInSWC = "";
        public String additionalConfigFilePath = "";
        public String additionalOptions = "";
    }
}

