/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildConfigurationEntryImpl
implements ModifiableBuildConfigurationEntry,
StatefulDependencyEntry {
    private final DependencyTypeImpl myDependencyType;
    private final ModulePointer myModulePointer;
    @NotNull
    private final String myBcName;

    public BuildConfigurationEntryImpl(@NotNull Module module, @NotNull String bcName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        if (bcName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        this(ModulePointerManager.getInstance((Project)module.getProject()).create(module), bcName);
    }

    public BuildConfigurationEntryImpl(@NotNull Project project, @NotNull String moduleName, @NotNull String bcName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        if (bcName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        this(ModulePointerManager.getInstance((Project)project).create(moduleName), bcName);
    }

    public BuildConfigurationEntryImpl(ModulePointer modulePointer, @NotNull String bcName) {
        if (bcName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "<init>"));
        }
        this.myDependencyType = new DependencyTypeImpl();
        this.myModulePointer = modulePointer;
        this.myBcName = bcName;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModulePointer.getModuleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "getModuleName"));
        }
        return string;
    }

    @Override
    @NotNull
    public DependencyTypeImpl getDependencyType() {
        DependencyTypeImpl dependencyTypeImpl = this.myDependencyType;
        if (dependencyTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "getDependencyType"));
        }
        return dependencyTypeImpl;
    }

    @Override
    @Nullable
    public Module findModule() {
        Module module = this.myModulePointer.getModule();
        return module != null && ModuleType.get((Module)module) instanceof FlexModuleType ? module : null;
    }

    @Override
    @Nullable
    public FlexBuildConfiguration findBuildConfiguration() {
        Module module = this.findModule();
        return module != null ? FlexBuildConfigurationManager.getInstance(module).findConfigurationByName(this.myBcName) : null;
    }

    @Override
    @NotNull
    public String getBcName() {
        String string = this.myBcName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/BuildConfigurationEntryImpl", "getBcName"));
        }
        return string;
    }

    public BuildConfigurationEntryImpl getCopy() {
        BuildConfigurationEntryImpl copy = new BuildConfigurationEntryImpl(this.myModulePointer, this.myBcName);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(ModifiableBuildConfigurationEntry copy) {
        this.myDependencyType.applyTo((ModifiableDependencyType)copy.getDependencyType());
    }

    @Override
    public boolean isEqual(ModifiableDependencyEntry other) {
        if (!(other instanceof BuildConfigurationEntryImpl)) {
            return false;
        }
        if (!this.myBcName.equals(((BuildConfigurationEntryImpl)other).myBcName)) {
            return false;
        }
        if (!this.getModuleName().equals(((BuildConfigurationEntryImpl)other).getModuleName())) {
            return false;
        }
        return this.myDependencyType.isEqual(((BuildConfigurationEntryImpl)other).myDependencyType);
    }

    @Override
    public EntryState getState() {
        EntryState state = new EntryState();
        state.MODULE_NAME = this.getModuleName();
        state.BC_NAME = this.myBcName;
        state.DEPENDENCY_TYPE = this.myDependencyType.getState();
        return state;
    }
}

