/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.detection;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.sdk.FlexSdkComboBoxWithBrowseButton;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class FlexSdkStep
extends ModuleWizardStep {
    private JPanel myContentPane;
    private FlexSdkComboBoxWithBrowseButton mySdkCombo;
    private JLabel mySdkLabel;
    private WizardContext myContext;

    public FlexSdkStep(WizardContext context) {
        this.myContext = context;
        this.$$$setupUI$$$();
        FlexSdkStep.selectSdkUsedByOtherModules(this.myContext.getProject(), this.mySdkCombo);
    }

    public JComponent getComponent() {
        this.mySdkLabel.setLabelFor(this.mySdkCombo.getChildComponent());
        String text = FlexBundle.message(this.myContext.getProject() != null ? "module.sdk.label" : "project.sdk.label", new Object[0]);
        this.mySdkLabel.setText(UIUtil.removeMnemonic((String)text));
        this.mySdkLabel.setDisplayedMnemonicIndex(UIUtil.getDisplayMnemonicIndex((String)text));
        this.mySdkCombo.setButtonEnabled(FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor() == null);
        return this.myContentPane;
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.mySdkCombo.getSelectedSdk());
    }

    private static void selectSdkUsedByOtherModules(@Nullable Project project, FlexSdkComboBoxWithBrowseButton combo) {
        if (project == null) {
            return;
        }
        FlexProjectConfigurationEditor currentEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        if (currentEditor != null) {
            Module[] modules;
            for (Module module : modules = ModuleStructureConfigurable.getInstance((Project)project).getModules()) {
                if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
                for (ModifiableFlexBuildConfiguration c : currentEditor.getConfigurations(module)) {
                    Sdk sdk;
                    SdkEntry sdkEntry = c.getDependencies().getSdkEntry();
                    if (sdkEntry == null || (sdk = FlexSdkUtils.findFlexOrFlexmojosSdk(sdkEntry.getName())) == null || sdk.getSdkType() != FlexSdkType2.getInstance()) continue;
                    combo.setSelectedSdkRaw(sdk.getName());
                    return;
                }
            }
        } else {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
                for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                    Sdk sdk = bc.getSdk();
                    if (sdk == null) continue;
                    combo.setSelectedSdkRaw(sdk.getName());
                    return;
                }
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FlexSdkComboBoxWithBrowseButton flexSdkComboBoxWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySdkLabel = jLabel = new JLabel();
        jLabel.setText("Project SDK:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySdkCombo = flexSdkComboBoxWithBrowseButton = new FlexSdkComboBoxWithBrowseButton();
        jPanel.add((Component)((Object)flexSdkComboBoxWithBrowseButton), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

