/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.lang.javascript.flex.projectStructure.conversion.ConversionParams;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import org.jdom.Element;

public class FlexWorkspaceConverter
extends ConversionProcessor<WorkspaceSettings> {
    private final ConversionParams myParams;

    public FlexWorkspaceConverter(ConversionParams params) {
        this.myParams = params;
    }

    public boolean isConversionNeeded(WorkspaceSettings workspaceSettings) {
        return true;
    }

    public void process(WorkspaceSettings workspaceSettings) throws CannotConvertException {
    }

    public void postProcess(WorkspaceSettings workspaceSettings) throws CannotConvertException {
        Collection<Pair<String, String>> moduleAndBCNames = this.myParams.getAppModuleAndBCNames();
        if (moduleAndBCNames.isEmpty()) {
            return;
        }
        Element runManagerComponent = workspaceSettings.getComponentElement("RunManager");
        if (runManagerComponent == null) {
            runManagerComponent = new Element("component");
            runManagerComponent.setAttribute("name", "RunManager");
            workspaceSettings.getRootElement().addContent(runManagerComponent);
        }
        for (Pair<String, String> moduleAndBCName : moduleAndBCNames) {
            FlexWorkspaceConverter.createRunConfiguration(runManagerComponent, (String)moduleAndBCName.first, (String)moduleAndBCName.second);
        }
    }

    private static void createRunConfiguration(Element runManagerComponent, String moduleName, String bcName) {
        Element configurationElement = new Element("configuration");
        configurationElement.setAttribute("default", "false");
        configurationElement.setAttribute("name", bcName);
        configurationElement.setAttribute("type", "FlashRunConfigurationType");
        configurationElement.setAttribute("factoryName", "Flash App");
        Element moduleNameOption = new Element("option");
        moduleNameOption.setAttribute("name", "moduleName");
        moduleNameOption.setAttribute("value", moduleName);
        configurationElement.addContent(moduleNameOption);
        Element bcNameOption = new Element("option");
        bcNameOption.setAttribute("name", "BCName");
        bcNameOption.setAttribute("value", bcName);
        configurationElement.addContent(bcNameOption);
        runManagerComponent.addContent(configurationElement);
        runManagerComponent.setAttribute("selected", "Flash App." + bcName);
    }
}

