/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.facet.impl.invalid.InvalidFacetManagerImpl;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.build.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.conversion.FlexModuleConverter;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationManagerImpl;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class ConversionParams {
    public static final String OLD_FLEX_SDK_TYPE_NAME = "Flex SDK Type";
    public static final String OLD_AIR_SDK_TYPE_NAME = "AIR SDK Type";
    public static final String OLD_AIR_MOBIE_SDK_TYPE_NAME = "AIR Mobile SDK Type";
    public static final String[] OLD_SDKS_TYPES = new String[]{"Flex SDK Type", "AIR SDK Type", "AIR Mobile SDK Type"};
    public String projectSdkName;
    private final Collection<Pair<String, String>> myAppModuleAndBCNames = new ArrayList<Pair<String, String>>();
    private final ConversionContext myContext;
    private final Collection<String> myFacetsToIgnore = new HashSet<String>();
    private Collection<String> myProjectLibrariesNames;
    private Set<String> myProjectLibrariesToMakeFlex = new HashSet<String>();

    public ConversionParams(ConversionContext context) {
        this.myContext = context;
    }

    public void ignoreInvalidFacet(String moduleName, String type, String name) {
        this.myFacetsToIgnore.add(FacetPointersManager.constructId((String)moduleName, (String)InvalidFacetType.TYPE_ID.toString(), (String)name));
    }

    public void apply() throws CannotConvertException {
        this.ignoreInvalidFacets();
    }

    private void ignoreInvalidFacets() throws CannotConvertException {
        if (!this.myFacetsToIgnore.isEmpty()) {
            Element invalidFacetManager = JDomSerializationUtil.findOrCreateComponentElement((Element)this.myContext.getWorkspaceSettings().getRootElement(), (String)"InvalidFacetManager");
            InvalidFacetManagerImpl.InvalidFacetManagerState state = (InvalidFacetManagerImpl.InvalidFacetManagerState)XmlSerializer.deserialize((Element)invalidFacetManager, InvalidFacetManagerImpl.InvalidFacetManagerState.class);
            state.getIgnoredFacets().addAll(this.myFacetsToIgnore);
            XmlSerializer.serializeInto((Object)state, (Element)invalidFacetManager);
        }
    }

    public boolean libraryExists(String libraryName, String libraryLevel) throws CannotConvertException {
        if ("application".equals(libraryLevel)) {
            LibraryEx library = (LibraryEx)ApplicationLibraryTable.getApplicationTable().getLibraryByName(libraryName);
            return library != null && ConversionParams.isApplicableLibrary(library);
        }
        if ("project".equals(libraryLevel)) {
            return this.myProjectLibrariesNames.contains(libraryName);
        }
        return false;
    }

    public String expandPath(String path) {
        return this.myContext.expandPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void convertFlexSdks() {
        void var7_11;
        Sdk sdk;
        void var7_9;
        ProjectJdkTable sdkTable = ProjectJdkTable.getInstance();
        Sdk[] allSdks = sdkTable.getAllJdks();
        FlexSdkType2 newSdkType = FlexSdkType2.getInstance();
        HashMap<String, Object> homePathToNewSdk = new HashMap<String, Object>();
        ArrayList<ProjectJdkImpl> sdksToAdd = new ArrayList<ProjectJdkImpl>();
        Sdk[] sdkArray = allSdks;
        int n = sdkArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            sdk = sdkArray[var7_9];
            if (sdk.getSdkType() == newSdkType && sdk.getHomePath() != null) {
                homePathToNewSdk.put(sdk.getHomePath(), sdk);
            }
            ++var7_9;
        }
        sdkArray = allSdks;
        n = sdkArray.length;
        boolean bl2 = false;
        while (var7_11 < n) {
            String homePath;
            String version;
            sdk = sdkArray[var7_11];
            if (ArrayUtil.contains((String)sdk.getSdkType().getName(), (String[])OLD_SDKS_TYPES) && (version = sdk.getVersionString()) != null && (version.startsWith("3.") || version.startsWith("4.")) && (homePath = sdk.getHomePath()) != null && !homePathToNewSdk.containsKey(homePath)) {
                String newSdkName = SdkConfigurationUtil.createUniqueSdkName((SdkType)newSdkType, (String)homePath, Arrays.asList(allSdks));
                ProjectJdkImpl newSdk = new ProjectJdkImpl(newSdkName, (SdkTypeId)newSdkType, homePath, "");
                newSdkType.setupSdkPaths((Sdk)newSdk);
                sdksToAdd.add(newSdk);
                homePathToNewSdk.put(homePath, newSdk);
            }
            ++var7_11;
        }
        AccessToken l = WriteAction.start();
        try {
            for (Sdk sdk2 : sdksToAdd) {
                sdkTable.addJdk(sdk2);
            }
        }
        finally {
            l.finish();
        }
    }

    private static boolean isApplicableLibrary(LibraryEx library) {
        return library.getKind() == null || library.getKind() == FlexLibraryType.FLEX_LIBRARY;
    }

    public void changeLibraryTypeToFlex(String libraryName, String libraryLevel) throws CannotConvertException {
        if ("application".equals(libraryLevel)) {
            Library library = ApplicationLibraryTable.getApplicationTable().getLibraryByName(libraryName);
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            model.setKind(FlexLibraryType.FLEX_LIBRARY);
            model.setProperties(FlexLibraryType.FLEX_LIBRARY.createDefaultProperties());
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        } else {
            this.myProjectLibrariesToMakeFlex.add(libraryName);
        }
    }

    public void setProjectLibrariesNames(Collection<String> librariesNames) {
        this.myProjectLibrariesNames = librariesNames;
    }

    public Set<String> getProjectLibrariesToMakeFlex() {
        return this.myProjectLibrariesToMakeFlex;
    }

    @Nullable
    public static Sdk findNewSdk(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/lang/javascript/flex/projectStructure/conversion/ConversionParams", "findNewSdk"));
        }
        List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)FlexSdkType2.getInstance());
        return (Sdk)ContainerUtil.find((Iterable)sdks, sdk -> {
            if (homePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/lang/javascript/flex/projectStructure/conversion/ConversionParams", "lambda$findNewSdk$1"));
            }
            return homePath.equals(sdk.getHomePath());
        });
    }

    void addAppModuleAndBCName(String moduleName, String bcName) {
        this.myAppModuleAndBCNames.add((Pair<String, String>)Pair.create((Object)moduleName, (Object)bcName));
    }

    public Collection<Pair<String, String>> getAppModuleAndBCNames() {
        return this.myAppModuleAndBCNames;
    }

    public Collection<String> getBcNamesForDependency(String moduleName, BuildConfigurationNature dependantNature) {
        ModuleSettings moduleSettings = this.myContext.getModuleSettings(moduleName);
        if (moduleSettings == null) {
            return Collections.emptyList();
        }
        if (FlexModuleConverter.isFlexModule(moduleSettings)) {
            Element flexBuildConfigurationElement = moduleSettings.getComponentElement("Flex.Build.Configuration");
            if (flexBuildConfigurationElement != null) {
                FlexBuildConfiguration oldConfiguration = (FlexBuildConfiguration)XmlSerializer.deserialize((Element)flexBuildConfigurationElement, FlexBuildConfiguration.class);
                if (oldConfiguration != null && "Library".equals(oldConfiguration.OUTPUT_TYPE)) {
                    return Collections.singletonList(FlexModuleConverter.generateModuleBcName(moduleSettings));
                }
            } else {
                Element buildConfigManagerElement = moduleSettings.getComponentElement("FlexBuildConfigurationManager");
                if (buildConfigManagerElement != null) {
                    FlexBuildConfigurationManagerImpl.State s = (FlexBuildConfigurationManagerImpl.State)XmlSerializer.deserialize((Element)buildConfigManagerElement, FlexBuildConfigurationManagerImpl.State.class);
                    return ContainerUtil.mapNotNull(s.CONFIGURATIONS, bcState -> bcState.OUTPUT_TYPE == OutputType.Library ? bcState.NAME : null);
                }
            }
            return Collections.emptyList();
        }
        List<Element> facets = FlexModuleConverter.getFlexFacets(moduleSettings);
        return ContainerUtil.mapNotNull(facets, facet -> {
            FlexBuildConfiguration oldConfiguration;
            Element oldConfigurationElement = facet.getChild("configuration");
            if (oldConfigurationElement != null && (oldConfiguration = (FlexBuildConfiguration)XmlSerializer.deserialize((Element)oldConfigurationElement, FlexBuildConfiguration.class)) != null && "Library".equals(oldConfiguration.OUTPUT_TYPE)) {
                return FlexModuleConverter.generateFacetBcName(facets, facet);
            }
            return null;
        });
    }
}

