/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlashBuildConfigurationsUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "Flash build configurations";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/projectStructure/FlashBuildConfigurationsUsagesCollector", "getProjectUsages"));
        }
        HashSet<String> usedBcs = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                usedBcs.add(bc.getStatisticsEntry());
            }
        }
        Set set = ContainerUtil.map2Set(usedBcs, s -> new UsageDescriptor(s, 1));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlashBuildConfigurationsUsagesCollector", "getProjectUsages"));
        }
        return set;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID, (double)0.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlashBuildConfigurationsUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

