/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootFilter;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class FlexSwcLibrariesRootDetector
extends RootFilter {
    public FlexSwcLibrariesRootDetector() {
        super(OrderRootType.CLASSES, false, FlexBundle.message("swc.libraries.root.detector.name", new Object[0]));
    }

    public boolean isAccepted(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/flex/library/FlexSwcLibrariesRootDetector", "isAccepted"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/flex/library/FlexSwcLibrariesRootDetector", "isAccepted"));
        }
        if (!rootCandidate.isDirectory()) {
            return false;
        }
        if (!"swc".equalsIgnoreCase(rootCandidate.getExtension()) && !"ane".equalsIgnoreCase(rootCandidate.getExtension())) {
            return false;
        }
        return rootCandidate.getFileSystem() instanceof JarFileSystem && rootCandidate.getParent() == null;
    }
}

