/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.library.FlexLibraryRootsDetector;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import icons.FlexIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsComponentDescriptor", "getRootTypePresentation"));
        }
        if (type instanceof JavadocOrderRootType) {
            return new OrderRootTypePresentation(FlexBundle.message("documentation.order.root.type.name", new Object[0]), FlexIcons.Flex.Documentation);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation((OrderRootType)type);
    }

    @NotNull
    public LibraryRootsDetector getRootsDetector() {
        FlexLibraryRootsDetector flexLibraryRootsDetector = new FlexLibraryRootsDetector();
        if (flexLibraryRootsDetector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsComponentDescriptor", "getRootsDetector"));
        }
        return flexLibraryRootsDetector;
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        throw new UnsupportedOperationException("should not be called");
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(String libraryName) {
        FileChooserDescriptor d = super.createAttachFilesChooserDescriptor(libraryName);
        d.setTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
        d.setDescription(FlexBundle.message("choose.library.files.description", ApplicationNamesInfo.getInstance().getFullProductName()));
        FileChooserDescriptor fileChooserDescriptor = d;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsComponentDescriptor", "createAttachFilesChooserDescriptor"));
        }
        return fileChooserDescriptor;
    }

    public String getAttachFilesActionName() {
        return FlexBundle.message("add.library.components.action.name", new Object[0]);
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AddDocUrlDescriptor> list = Arrays.asList(new AddDocUrlDescriptor());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsComponentDescriptor", "createAttachButtons"));
        }
        return list;
    }

    private static class AddDocUrlDescriptor
    extends AttachRootButtonDescriptor {
        private AddDocUrlDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), FlexBundle.message("add.doc.url.button", new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @Nullable LibraryEditor libraryEditor) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsComponentDescriptor$AddDocUrlDescriptor", "selectFiles"));
            }
            VirtualFile vFile = Util.showSpecifyJavadocUrlDialog((JComponent)parent);
            if (vFile != null) {
                return new VirtualFile[]{vFile};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
    }
}

