/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.AbstractDumpProcessor;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AbcDumper
extends AbstractDumpProcessor {
    private final boolean dumpCode;

    public AbcDumper(boolean _dumpCode) {
        this.dumpCode = _dumpCode;
    }

    @Override
    public void dumpStat(@NotNull String stat) {
        if (stat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stat", "com/intellij/lang/javascript/flex/importer/AbcDumper", "dumpStat"));
        }
        this.sb.append(stat);
    }

    @Override
    public void hasError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/lang/javascript/flex/importer/AbcDumper", "hasError"));
        }
        this.sb.append(error);
    }

    @Override
    protected String appendModifiers(MemberInfo member, String attr) {
        attr = attr + (member instanceof MethodInfo && (((MethodInfo)member).flags & 0x20) != 0 ? "native " : "");
        return attr;
    }

    @Override
    public void processMultinameAsPackageName(@NotNull Multiname name, @Nullable String parentName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/importer/AbcDumper", "processMultinameAsPackageName"));
        }
        this.append(name.hasNotEmptyNs() ? name.getValidNsName(this.classNameTable) + "::" + name.name : name.name);
    }

    @Override
    public void dumpToplevelAnonymousMethod(@NotNull Abc abc, @NotNull MethodInfo m) {
        if (abc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abc", "com/intellij/lang/javascript/flex/importer/AbcDumper", "dumpToplevelAnonymousMethod"));
        }
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/lang/javascript/flex/importer/AbcDumper", "dumpToplevelAnonymousMethod"));
        }
        m.dump(abc, "", "", this);
    }

    @Override
    public void dumpTopLevelTraits(Abc abc, @NotNull Traits t, String indent) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/lang/javascript/flex/importer/AbcDumper", "dumpTopLevelTraits"));
        }
        this.sb.append(indent + t.name + "\n");
        t.dump(abc, indent, "", this);
        t.init.dump(abc, indent, "", this);
    }

    @Override
    public boolean doDumpMember(@NotNull MemberInfo memberInfo) {
        if (memberInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfo", "com/intellij/lang/javascript/flex/importer/AbcDumper", "doDumpMember"));
        }
        return true;
    }

    @Override
    public void appendMethodSeparator() {
        this.append("\n");
    }

    @Override
    public void appendFieldSeparator() {
        this.append("");
    }

    @Override
    public String getAbcInSwfIndent() {
        return "  ";
    }

    @Override
    public void processValue(Multiname type, Object value) {
        this.append(" = " + String.valueOf(value instanceof String ? '\"' + value.toString() + '\"' : value));
    }

    @Override
    public boolean doDumpMetaData(@NotNull MetaData md) {
        if (md == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "md", "com/intellij/lang/javascript/flex/importer/AbcDumper", "doDumpMetaData"));
        }
        return true;
    }

    @Override
    public void processParameter(@NotNull String name, @Nullable Multiname type, String parentName, @Nullable Multiname value, boolean rest) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/importer/AbcDumper", "processParameter"));
        }
        this.processMultinameAsPackageName(type, parentName);
    }

    @Override
    public boolean doStarTypeDumpInExtends() {
        return true;
    }

    @Override
    public boolean doStarMetaAttrNameDump() {
        return true;
    }

    @Override
    public void setProcessingInterface(boolean anInterface) {
    }

    @Override
    protected boolean dumpRestParameter() {
        return false;
    }

    @Override
    public void processFunction(MethodInfo methodInfo, boolean referenceNameRequested, Abc abc, String indent, String attr) {
        super.processFunction(methodInfo, referenceNameRequested, abc, indent, attr);
        this.append("\t/* disp_id " + methodInfo.id + "*/");
        if (!referenceNameRequested) {
            this.append("\n");
            if (this.dumpCode && methodInfo.code != null) {
                methodInfo.dumpCode(abc, indent, this);
            }
        }
    }

    @Override
    public void processVariable(SlotInfo info, String indent, String attr) {
        super.processVariable(info, indent, attr);
        this.append("\t/* slot_id " + info.id + " */\n");
    }
}

