/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitInspectionVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class FlexUnitSuiteInspectionBase
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FlexBundle.message("flexunit.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitSuiteInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitSuiteInspectionBase", "buildVisitor"));
        }
        FlexUnitInspectionVisitor flexUnitInspectionVisitor = new FlexUnitInspectionVisitor(){

            public void visitJSClass(JSClass aClass) {
                FlexUnitSupport support = this.getFlexUnitSupport((PsiElement)aClass);
                if (support == null || !support.isSuite(aClass)) {
                    return;
                }
                FlexUnitSuiteInspectionBase.this.visitSuite(aClass, holder, support);
            }
        };
        if (flexUnitInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitSuiteInspectionBase", "buildVisitor"));
        }
        return flexUnitInspectionVisitor;
    }

    protected abstract void visitSuite(JSClass var1, @NotNull ProblemsHolder var2, FlexUnitSupport var3);
}

