/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitClassInspectionBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitClassInProductSourceInspection
extends FlexUnitClassInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testclassinproductsource.displayname", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitClassInProductSourceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "getShortName"));
        }
        return "FlexUnitClassInProductSourceInspection";
    }

    @Override
    protected void visitPotentialTestClass(JSClass aClass, @NotNull ProblemsHolder holder, FlexUnitSupport support) {
        ASTNode nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "visitPotentialTestClass"));
        }
        VirtualFile file = aClass.getContainingFile().getVirtualFile();
        if (file == null) {
            return;
        }
        if (!ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInTestSourceContent(file) && (nameIdentifier = aClass.findNameIdentifier()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MoveClassFix(aClass);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("flexunit.inspection.testclassinproductsource.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    private class MoveClassFix
    implements LocalQuickFix,
    IntentionAction {
        private final JSClass myClass;

        public MoveClassFix(JSClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            if ("Move class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "getText"));
            }
            return "Move class";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "isAvailable"));
            }
            return this.myClass.isValid();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "invoke"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "lambda$invoke$0"));
                }
                RefactoringActionHandlerFactory.getInstance().createMoveHandler().invoke(project, editor, file, DataManager.getInstance().getDataContext());
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "applyFix"));
            }
            this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
        }
    }
}

