/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateFlexUnitTestDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myTestClassNameTextField;
    private JSReferenceEditor myPackageCombo;
    private JCheckBox myCreateTestSourceFolderCheckBox;
    private JTextField myTestSourceFolderTextField;
    private JSReferenceEditor mySuperClassField;
    private JCheckBox mySetUpCheckBox;
    private JCheckBox myTearDownCheckBox;
    private JSMemberSelectionPanel myMemberSelectionPanel;
    private final Module myModule;
    private final JSClass myContextClass;
    private PsiDirectory myTargetDirectory;
    private JSClass mySuperClass;
    private final PsiDirectory myExistingTestSourceRoot;
    private static final String CREATE_TEST_SOURCE_FOLDER_KEY = "CreateTestSourceFolder";

    public CreateFlexUnitTestDialog(Module module, JSClass contextClass) {
        super(module.getProject());
        this.myModule = module;
        this.myContextClass = contextClass;
        this.$$$setupUI$$$();
        this.myTestClassNameTextField.setText(this.myContextClass.getName() + "Test");
        this.setTitle(CodeInsightBundle.message((String)"intention.create.test", (Object[])new Object[0]));
        this.myExistingTestSourceRoot = CreateFlexUnitTestDialog.findExistingTestSourceRoot(module);
        this.myCreateTestSourceFolderCheckBox.setVisible(this.myExistingTestSourceRoot == null);
        this.myTestSourceFolderTextField.setVisible(this.myExistingTestSourceRoot == null);
        this.myTestSourceFolderTextField.setText(FileUtil.toSystemDependentName((String)CreateFlexUnitTestDialog.suggestTestSourceRootPath(module, contextClass.getContainingFile().getVirtualFile())));
        this.myCreateTestSourceFolderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFlexUnitTestDialog.this.myTestSourceFolderTextField.setEnabled(CreateFlexUnitTestDialog.this.myCreateTestSourceFolderCheckBox.isSelected());
            }
        });
        this.myCreateTestSourceFolderCheckBox.setSelected(PropertiesComponent.getInstance((Project)module.getProject()).getBoolean(CREATE_TEST_SOURCE_FOLDER_KEY, true));
        this.myTestSourceFolderTextField.setEnabled(this.myCreateTestSourceFolderCheckBox.isSelected());
        this.init();
    }

    private static String suggestTestSourceRootPath(Module module, VirtualFile file) {
        ContentEntry contentEntry;
        if (file != null && (contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)ModuleRootManager.getInstance((Module)module), (VirtualFile)file)) != null) {
            String basePath;
            boolean mavenStyle = false;
            for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                if (!srcRoot.getUrl().equals(contentEntry.getUrl() + "/src/main/flex")) continue;
                mavenStyle = true;
                break;
            }
            String path = basePath = VfsUtilCore.urlToPath((String)contentEntry.getUrl()) + (mavenStyle ? "/src/test/flex" : "/testSrc");
            int i = 0;
            while (LocalFileSystem.getInstance().findFileByPath(path) != null) {
                path = basePath + ++i;
            }
            return path;
        }
        return "";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTestClassNameTextField;
    }

    private void createUIComponents() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myContextClass);
        assert (module != null);
        this.myPackageCombo = JSReferenceEditor.forPackageName((String)StringUtil.getPackageName((String)this.myContextClass.getQualifiedName()), (Project)module.getProject(), null, (GlobalSearchScope)CreateFlexUnitTestDialog.getTestClassPackageScope(module), (String)RefactoringBundle.message((String)"choose.destination.package"));
        Condition filter = jsClass -> {
            JSAttributeList attributeList = jsClass.getAttributeList();
            return !jsClass.isInterface() && attributeList != null && !attributeList.hasModifier(JSAttributeList.ModifierType.FINAL);
        };
        this.mySuperClassField = JSReferenceEditor.forClassName((String)"", (Project)module.getProject(), null, (GlobalSearchScope)CreateFlexUnitTestDialog.getSuperClassScope(module), null, (Condition)filter, (String)JSBundle.message((String)"choose.super.class.title", (Object[])new Object[0]));
        ArrayList memberInfos = new ArrayList();
        JSMemberInfo.extractClassMembers((JSClass)this.myContextClass, memberInfos, (MemberInfoBase.Filter)new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                JSAttributeList attributeList = member.getAttributeList();
                return member instanceof JSFunction && ((JSFunction)member).getKind() != JSFunction.FunctionKind.CONSTRUCTOR && attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC;
            }
        });
        this.myMemberSelectionPanel = new JSMemberSelectionPanel("Generate test methods for:", memberInfos, null);
    }

    protected ValidationInfo doValidate() {
        if (this.myCreateTestSourceFolderCheckBox.isVisible() && this.myCreateTestSourceFolderCheckBox.isSelected()) {
            String path = FileUtil.toSystemIndependentName((String)this.myTestSourceFolderTextField.getText().trim());
            if (path.isEmpty()) {
                return new ValidationInfo("Path is empty", (JComponent)this.myTestSourceFolderTextField);
            }
            if (LocalFileSystem.getInstance().findFileByPath(path) != null) {
                return new ValidationInfo("File or folder already exists", (JComponent)this.myTestSourceFolderTextField);
            }
            boolean underContentRoot = false;
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
                if (!path.startsWith(contentRoot.getPath() + "/")) continue;
                underContentRoot = true;
                break;
            }
            if (!underContentRoot) {
                return new ValidationInfo("Test source folder must be under module content root", (JComponent)this.myTestSourceFolderTextField);
            }
        }
        return null;
    }

    protected void doOKAction() {
        String superClassFqn = this.mySuperClassField.getText().trim();
        PsiElement element = ActionScriptClassResolver.findClassByQNameStatic(superClassFqn, CreateFlexUnitTestDialog.getSuperClassScope(this.myModule));
        JSClass jSClass = this.mySuperClass = element instanceof JSClass ? (JSClass)element : null;
        if (this.myCreateTestSourceFolderCheckBox.isVisible() && this.myCreateTestSourceFolderCheckBox.isSelected()) {
            this.myTargetDirectory = CreateFlexUnitTestDialog.createTestSourceFolderAndPackage(this.myModule, this.myTestSourceFolderTextField.getText().trim(), this.getPackageName());
        }
        if (this.myTargetDirectory == null) {
            this.myTargetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)this.myModule.getProject(), (Module)this.myModule, (GlobalSearchScope)CreateFlexUnitTestDialog.getTestClassPackageScope(this.myModule), (String)this.getPackageName(), (String)this.getTestClassName(), (PsiDirectory)this.myExistingTestSourceRoot, (ThreeState)ThreeState.YES);
        }
        if (this.myTargetDirectory != null) {
            if (this.myCreateTestSourceFolderCheckBox.isVisible()) {
                PropertiesComponent.getInstance((Project)this.myModule.getProject()).setValue(CREATE_TEST_SOURCE_FOLDER_KEY, this.myCreateTestSourceFolderCheckBox.isSelected(), true);
            }
            super.doOKAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PsiDirectory createTestSourceFolderAndPackage(Module module, String srcRootPath, final String packageName) {
        final String path = FileUtil.toSystemIndependentName((String)srcRootPath);
        VirtualFile contentRoot = null;
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!path.startsWith(root.getPath() + "/")) continue;
            contentRoot = root;
            break;
        }
        if (contentRoot != null) {
            final ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                final VirtualFile finalContentRoot = contentRoot;
                VirtualFile folder = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<VirtualFile>(){

                    public VirtualFile compute() {
                        try {
                            VirtualFile srcRoot = VfsUtil.createDirectoryIfMissing((VirtualFile)finalContentRoot, (String)path.substring((finalContentRoot.getPath() + "/").length()));
                            VirtualFile folder = packageName.isEmpty() ? srcRoot : VfsUtil.createDirectoryIfMissing((VirtualFile)srcRoot, (String)packageName.replace('.', '/'));
                            ContentEntry contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)folder);
                            if (contentEntry != null) {
                                contentEntry.addSourceFolder(srcRoot, true);
                                model.commit();
                                return folder;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                PsiDirectory psiDirectory = folder == null ? null : PsiManager.getInstance((Project)module.getProject()).findDirectory(folder);
                return psiDirectory;
            }
            finally {
                if (model.isWritable()) {
                    model.dispose();
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiDirectory findExistingTestSourceRoot(Module module) {
        PsiDirectory testSourceRoot = null;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile srcRoot : manager.getSourceRoots(true)) {
            if (!manager.getFileIndex().isInTestSourceContent(srcRoot)) continue;
            testSourceRoot = PsiManager.getInstance((Project)module.getProject()).findDirectory(srcRoot);
            break;
        }
        return testSourceRoot;
    }

    private static GlobalSearchScope getSuperClassScope(Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
    }

    private static GlobalSearchScope getTestClassPackageScope(Module module) {
        return GlobalSearchScope.moduleWithDependentsScope((Module)module);
    }

    public String getTestClassName() {
        return this.myTestClassNameTextField.getText().trim();
    }

    public String getPackageName() {
        return this.myPackageCombo.getText().trim();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    @Nullable
    public JSClass getSuperClass() {
        return this.mySuperClass;
    }

    public boolean isGenerateSetUp() {
        return this.mySetUpCheckBox.isSelected();
    }

    public boolean isGenerateTearDown() {
        return this.myTearDownCheckBox.isSelected();
    }

    public JSMemberInfo[] getSelectedMemberInfos() {
        return JSMemberInfo.getSelected((Collection)this.myMemberSelectionPanel.getTable().getSelectedMemberInfos(), (JSClass)this.myContextClass, (Condition)Conditions.alwaysTrue());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Test class name:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestClassNameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JSMemberSelectionPanel jSMemberSelectionPanel = this.myMemberSelectionPanel;
        jPanel.add((Component)jSMemberSelectionPanel, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Super class:");
        jLabel2.setDisplayedMnemonic('S');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Generate:");
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.mySuperClassField;
        jPanel.add((Component)jSReferenceEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Destination package:");
        jLabel4.setDisplayedMnemonic('D');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor2 = this.myPackageCombo;
        jPanel.add((Component)jSReferenceEditor2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySetUpCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("setUp()");
        jCheckBox3.setMnemonic('U');
        jCheckBox3.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTearDownCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("tearDown()");
        jCheckBox2.setMnemonic('E');
        jCheckBox2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCreateTestSourceFolderCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create test source folder:");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestSourceFolderTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor((Component)jSReferenceEditor);
        jLabel4.setLabelFor((Component)jSReferenceEditor2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

